/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportCreateHelperTest.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.processor;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Map;

import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.exporter.OoPdfExporter;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.tag.BlockColRepeatParamParser;
import org.bbreak.excella.reports.tag.BlockRowRepeatParamParser;
import org.bbreak.excella.reports.tag.ColRepeatParamParser;
import org.bbreak.excella.reports.tag.ImageParamParser;
import org.bbreak.excella.reports.tag.RemoveParamPaser;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.tag.RowRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;
import org.bbreak.excella.reports.tag.SumParamParser;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.processor.ReportCreateHelper} ̂߂̃eXgENXB
 * 
 * @since 1.0
 */
public class ReportCreateHelperTest {

    @Test
    public void testCreateDefaultParsers() {
        // ftHg
        Map<String, ReportsTagParser<?>> parsers = ReportCreateHelper.createDefaultParsers();

        assertEquals( 8, parsers.size());
        for ( ReportsTagParser<?> parser : parsers.values()) {
            if ( parser.getTag().equals( SingleParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof SingleParamParser);
            } else if ( parser.getTag().equals( ImageParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof ImageParamParser);
            } else if ( parser.getTag().equals( RowRepeatParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof RowRepeatParamParser);
            } else if ( parser.getTag().equals( ColRepeatParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof ColRepeatParamParser);
            } else if ( parser.getTag().equals( BlockRowRepeatParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof BlockRowRepeatParamParser);
            } else if ( parser.getTag().equals( BlockColRepeatParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof BlockColRepeatParamParser);
            } else if ( parser.getTag().equals( SumParamParser.DEFAULT_TAG)) {
                assertTrue( parser instanceof SumParamParser);
            } else if ( parser.getTag().equals( RemoveParamPaser.DEFAULT_TAG)) {
                assertTrue( parser instanceof RemoveParamPaser);
            } else {
                fail( "ftHgłȂp[T[L");
            }
        }

    }

    @Test
    public void testCreateDefaultExporters() {
        // ftHg
        Map<String, ReportBookExporter> exporters = ReportCreateHelper.createDefaultExporters();

        assertEquals( 2, exporters.size());
        for ( ReportBookExporter exporter : exporters.values()) {
            if ( exporter.getFormatType().equals( ExcelExporter.FORMAT_TYPE)) {
                assertTrue( exporter instanceof ExcelExporter);
            } else if ( exporter.getFormatType().equals( OoPdfExporter.FORMAT_TYPE)) {
                assertTrue( exporter instanceof OoPdfExporter);
            } else {
                fail( "ftHgłȂp[T[L");
            }
        }

    }
}
