/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ColRepeatParamParser.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.util.ReportsUtil;

/**
 * V[g̒uɌJԂϊp[T
 * 
 * @since 1.0
 */
public class ColRepeatParamParser extends ReportsTagParser<Object[]> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( ColRepeatParamParser.class);

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$C[]";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * d\̒p[^
     */
    protected static final String PARAM_DUPLICATE = "hideDuplicate";

    /**
     * JԂő
     */
    public static final String PARAM_REPEAT_NUM = "repeatNum";

    /**
     * V[gւ̃nCp[NݒL
     */
    public static final String PARAM_SHEET_LINK = "sheetLink";

    /**
     * V[gϐ̕ϐ
     */
    public static final String PARAM_PROPERTY = "property";

    /**
     * RXgN^
     */
    public ColRepeatParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ColRepeatParamParser( String tag) {
        super( tag);
    }

    @Override
    public boolean useControlRow() {
        return false;
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

        // p[^`FbN
        checkParam( paramDef, tagCell);

        String tag = tagCell.getStringCellValue();
        ReportsParserInfo info = ( ReportsParserInfo) data;
        ParamInfo paramInfo = info.getParamInfo();
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();

        // ul
        Object[] paramValues = null;
        try {
            // uϐ̎擾
            String replaceParam = paramDef.get( PARAM_VALUE);

            // JԂő
            Integer repeatNum = null;
            if ( paramDef.containsKey( PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf( paramDef.get( PARAM_REPEAT_NUM));
            }

            // V[gnCp[NݒL
            boolean sheetLink = false;
            if ( paramDef.containsKey( PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf( paramDef.get( PARAM_SHEET_LINK));
            }

            // V[gϐ
            String propertyName = null;
            if ( paramDef.containsKey( PARAM_PROPERTY)) {
                propertyName = paramDef.get( PARAM_PROPERTY);
            }

            // d\̐ݒL
            boolean duplicate = false;
            if ( paramDef.containsKey( PARAM_DUPLICATE)) {
                duplicate = Boolean.valueOf( paramDef.get( PARAM_DUPLICATE));
            }

            // VXeϐ
            if ( ReportsUtil.VALUE_SHEET_NAMES.equals( replaceParam)) {
                // V[g
                paramValues = ReportsUtil.getSheetNames( info.getReportBook()).toArray();
            } else if ( ReportsUtil.VALUE_SHEET_VALUES.equals( replaceParam)) {
                // V[gl
                paramValues = ReportsUtil.getSheetValues( info.getReportBook(), propertyName, info.getReportParsers()).toArray();
            } else {
                // ul擾
                if ( paramInfo != null) {
                    paramValues = getParamData( paramInfo, replaceParam);
                }
            }

            if ( paramValues == null || paramValues.length == 0) {
                // 󕶎u
                paramValues = new Object[] {null};
            }

            // p[^d
            if ( duplicate && paramValues.length > 1) {
                List<Object> paramValuesList = new ArrayList<Object>();
                for ( int i = 0; i <= paramValues.length - 1; i++) {
                    // dǉ
                    if ( !paramValuesList.contains( paramValues[i])) {
                        paramValuesList.add( paramValues[i]);
                    } else {
                        paramValuesList.add( null);
                    }
                }
                paramValues = paramValuesList.toArray();
            }

            int shiftNum = paramValues.length;
            if ( repeatNum != null && repeatNum < shiftNum) {
                shiftNum = repeatNum;
            }

            // Pł΁AVtgȂ
            if ( shiftNum > 1) {
                // l̐Vtg
                CellRangeAddress rangeAddress = new CellRangeAddress( tagCell.getRowIndex(), tagCell.getRowIndex(), tagCell.getColumnIndex(), tagCell.getColumnIndex() + shiftNum - 2);
                PoiUtil.insertRangeRight( sheet, rangeAddress);

                int tagCellWidth = sheet.getColumnWidth( tagCell.getColumnIndex());
                for ( int i = tagCell.getColumnIndex() + 1; i <= tagCell.getColumnIndex() + shiftNum - 2; i++) {
                    int colWidth = sheet.getColumnWidth( i);
                    if ( colWidth < tagCellWidth) {
                        sheet.setColumnWidth( i, tagCellWidth);
                    }
                }
            }

            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName( workbook.getSheetIndex( sheet));
            //V[g
            List<String> sheetNames = ReportsUtil.getSheetNames( info.getReportBook());
            //ϊl
            List<Object> resultValues = new ArrayList<Object>();
            //Oϊl
            Object beforeValue = null;
            for ( int i = 0; i < shiftNum; i++) {
                Row row = sheet.getRow( tagCell.getRowIndex());
                Cell cell = row.getCell( tagCell.getColumnIndex() + i);
                if ( cell == null) {
                    cell = row.createCell( tagCell.getColumnIndex() + i);
                }
                // Rs[(X^C̐ݒ)
                PoiUtil.copyCell( tagCell, cell);
                //u
                Object value = null;
                if ( beforeValue == null || !(duplicate && beforeValue.equals( paramValues[i]))) {
                    value = paramValues[i];
                    beforeValue = paramValues[i];
                }
                if ( log.isDebugEnabled()) {
                    log.debug( "[V[g=" + sheetName + ",Z=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + "  " + paramValues[i]);
                }
                // u
                PoiUtil.setCellValue( cell, value);
                resultValues.add(value);
                // N
                if ( sheetLink) {
                    if ( i < sheetNames.size()) {
                        PoiUtil.setHyperlink( cell, Hyperlink.LINK_DOCUMENT, "'" + sheetNames.get( i) + "'!A1");
                        if ( log.isDebugEnabled()) {
                            log.debug( "[V[g=" + sheetName + ",Z=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink  " + "'" + sheetNames.get( i) + "'!A1");
                        }
                    }
                }
            }

            parsedReportInfo.setDefaultRowIndex( tagCell.getRowIndex());
            parsedReportInfo.setDefaultColumnIndex( tagCell.getColumnIndex());
            parsedReportInfo.setRowIndex( tagCell.getRowIndex());
            parsedReportInfo.setColumnIndex( tagCell.getColumnIndex() + shiftNum - 1);
            parsedReportInfo.setParsedObject( resultValues);
            if ( log.isDebugEnabled()) {
                log.debug(parsedReportInfo);
            }
            return parsedReportInfo;
            
        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef
     * @param tagCell
     * @throws ParseException
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
        // L[
        if ( paramDef.containsKey( PARAM_DUPLICATE) && paramDef.containsKey( PARAM_SHEET_LINK)) {
            throw new ParseException( tagCell, "d`F" + PARAM_DUPLICATE + "," + PARAM_SHEET_LINK);
        }
    }

}
