/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: BlockRowRepeatParamParserTest.java 33 2009-09-29 03:23:21Z tsuchida $
 * $Revision: 33 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.model.ConvertConfiguration;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.CellObject;
import org.bbreak.excella.reports.processor.ReportCreateHelper;
import org.bbreak.excella.reports.processor.ReportsCheckException;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.processor.ReportsWorkbookTest;
import org.junit.Test;


public class BlockRowRepeatParamParserTest  extends ReportsWorkbookTest {
    
    /**
     * RXgN^
     * @param version GNZo[W
     */
    public BlockRowRepeatParamParserTest( String version) {
        super(version);
    }
    
    @Test
    public void testParseSheetCellObject() throws ParseException {
        Workbook workbook = null;
        
        ReportBook reportBook = new ReportBook( "", "test", new ConvertConfiguration[] {});
        ReportSheet reportSheet1 = new ReportSheet( "sheet1", "Sheet1");
        reportBook.addReportSheet( reportSheet1);
        ReportSheet reportSheet2 = new ReportSheet( "sheet1", "Sheet2");
        reportBook.addReportSheet( reportSheet2);
        
        
        ReportSheet[] reportSheets = new ReportSheet[] {reportSheet1, reportSheet2};
        
        // -----------------------
        // eXgf[^
        // -----------------------
        
        //qubN1f[^
        ParamInfo inBlockInfo1 = new ParamInfo();
        inBlockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR1-C-A1", "inBR1-C-A2", "inBR1-C-A3"});
        inBlockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"inBR1-C-B1", "inBR1-C-B1"});
        inBlockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"inBR1-C-C1"});
        
        inBlockInfo1.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR1-R-A1"});
        
        inBlockInfo1.addParam(SingleParamParser.DEFAULT_TAG, "D", "inBR1-S-DDD");
        
        //qubN2f[^
        ParamInfo inBlockInfo2 = new ParamInfo();
        inBlockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR2-C-A1"});
        inBlockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"inBR2-C-B1", "inBR2-C-B2"});
        inBlockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"inBR2-C-C1", "inBR2-C-C2", "inBR2-C-C3"});
        
        inBlockInfo2.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR2-R-A1", "inBR2-R-A2", "inBR2-R-A3"});
        
        inBlockInfo2.addParam(SingleParamParser.DEFAULT_TAG, "D", "inBR2-S-DDD");
        
        //qubN3f[^
        ParamInfo inBlockInfo3 = new ParamInfo();
        inBlockInfo3.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR3-C-A1", "inBR3-C-A2", "inBR3-C-A3"});
        inBlockInfo3.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"inBR3-C-B1", "inBR3-C-B2", "inBR3-C-B3", "inBR3-C-B4"});
        inBlockInfo3.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"inBR3-C-C1", "inBR3-C-C2", "inBR3-C-C3", "inBR3-C-C4", "inBR3-C-C5"});
        
        inBlockInfo3.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR3-R-A1", "inBR3-R-A2", "inBR3-R-A3", "inBR3-R-A4", "inBR3-R-A5"});
        
        inBlockInfo3.addParam(SingleParamParser.DEFAULT_TAG, "D", "inBR3-S-DDD");
        
        //qubN4f[^
        ParamInfo inBlockInfo4 = new ParamInfo();
        inBlockInfo4.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR4-C-A1", "inBR4-C-A2", "inBR4-C-A3", "inBR4-C-A4", "inBR4-C-A5"});
        inBlockInfo4.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"inBR4-C-B1", "inBR4-C-B2", "inBR4-C-B3", "inBR4-C-B4"});
        inBlockInfo4.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"inBR4-C-C1", "inBR4-C-C2", "inBR4-C-C3"});
        
        inBlockInfo4.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"inBR4-R-A1", "inBR4-R-A2"});
        
        inBlockInfo4.addParam(SingleParamParser.DEFAULT_TAG, "D", "inBR4-S-DDD");
        
        //BRubN1f[^
        ParamInfo blockInfo1 = new ParamInfo();
        blockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"BR1-C-A1", "BR1-C-A2", "BR1-C-A3", "BR1-C-A4", "BR1-C-A5"});
        blockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"BR1-C-B1", "BR1-C-B2", "BR1-C-B3", "BR1-C-B4"});
        blockInfo1.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"BR1-C-C1", "BR1-C-C2", "BR1-C-C3"});
        
        blockInfo1.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"BR1-R-A1", "BR1-R-A2", "BR1-R-A3", "BR1-R-A4", "BR1-R-A5"});
        blockInfo1.addParam( RowRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"BR1-R-B1", "BR1-R-B2", "BR1-R-B3", "BR1-R-B4"});
        blockInfo1.addParam( RowRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"BR1-R-C1", "BR1-R-C2", "BR1-R-C3"});
        
        blockInfo1.addParam(SingleParamParser.DEFAULT_TAG, "D", "BR1-S-DDD");
        blockInfo1.addParam(SingleParamParser.DEFAULT_TAG, "D2", "BR1-S-DDD2");
        
        blockInfo1.addParam(BlockColRepeatParamParser.DEFAULT_TAG, "inBR1", new Object[] {inBlockInfo1, inBlockInfo2});
        blockInfo1.addParam(BlockRowRepeatParamParser.DEFAULT_TAG, "inBR1", new Object[] {inBlockInfo1, inBlockInfo2});
        
        //BCubN2f[^
        ParamInfo blockInfo2 = new ParamInfo();
        blockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"BR2-C-A1", "BR2-C-A2", "BR2-C-A3", "BR2-C-A4"});
        blockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"BR2-C-B1", "BR2-C-B2", "BR2-C-B3", "BR2-C-B4", "BR2-C-B5"});
        blockInfo2.addParam( ColRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"BR2-C-C1", "BR2-C-C2", "BR2-C-C3"});
        
        blockInfo2.addParam( RowRepeatParamParser.DEFAULT_TAG, "A", new Object[] {"BR2-R-A1", "BR2-R-A2", "BR2-R-A3", "BR2-R-A4"});
        blockInfo2.addParam( RowRepeatParamParser.DEFAULT_TAG, "B", new Object[] {"BR2-R-B1", "BR2-R-B2", "BR2-R-B3", "BR2-R-B4", "BR2-R-B5"});
        blockInfo2.addParam( RowRepeatParamParser.DEFAULT_TAG, "C", new Object[] {"BR2-R-C1", "BR2-R-C2", "BR2-R-C3"});
        
        blockInfo2.addParam(SingleParamParser.DEFAULT_TAG, "D", "BR2-S-DDD");
        blockInfo2.addParam(SingleParamParser.DEFAULT_TAG, "D2", "BR2-S-DDD2");
        
        blockInfo2.addParam(BlockColRepeatParamParser.DEFAULT_TAG, "inBR1", new Object[] {inBlockInfo3, inBlockInfo4});
        blockInfo2.addParam(BlockRowRepeatParamParser.DEFAULT_TAG, "inBR1", new Object[] {inBlockInfo3, inBlockInfo4});
        
        //BCubN3f[^
        ParamInfo blockInfo3 = new ParamInfo();
        blockInfo3.addParam(SingleParamParser.DEFAULT_TAG, "D", "BR2-S-DDD");
        blockInfo3.addParam(SingleParamParser.DEFAULT_TAG, "D2", "BR2-S-DDD2");

        //BCubN4f[^
        ParamInfo blockInfo4 = new ParamInfo();
        blockInfo4.addParam(SingleParamParser.DEFAULT_TAG, "D", "BR2-S-DDD");
        blockInfo4.addParam(SingleParamParser.DEFAULT_TAG, "D2", "BR2-S-DDD2");

        //BCubN5f[^
        ParamInfo blockInfo5 = new ParamInfo();
        blockInfo5.addParam(SingleParamParser.DEFAULT_TAG, "D", "BR5-S-DDD");
        blockInfo5.addParam(SingleParamParser.DEFAULT_TAG, "D2", "BR5-S-DDD2");
        
        for (int i = 0; i < reportSheets.length; i++) {
            ParamInfo info = reportSheets[i].getParamInfo();
            if (i == 1) {
                info.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "BR1", new Object[]{blockInfo1, blockInfo2, blockInfo3, blockInfo4, blockInfo5});
            } else {
                info.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "BR1", new Object[]{blockInfo1, blockInfo2});    
            }
        }

        BlockRowRepeatParamParser parser = new BlockRowRepeatParamParser();
        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setReportParsers( new ArrayList<ReportsTagParser<?>>( ReportCreateHelper.createDefaultParsers().values()));
        reportsParserInfo.setReportBook( reportBook);
        reportsParserInfo.setParamInfo( reportSheets[0].getParamInfo());
        
        
        // ͏
        List<ParsedReportInfo> results = null;
        CellObject[] expectBeCells = null;
        CellObject[] expectAfCells = null;
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-C
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet1 = workbook.getSheetAt( 0);
        results = parseSheet( parser, sheet1, reportsParserInfo);
        expectBeCells = new CellObject[] {new CellObject( 3, 3)};
        expectAfCells = new CellObject[] {new CellObject( 6, 7)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "Sheet1", sheet1, true);
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-C2
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet2 = workbook.getSheetAt( 1);
        
        results = parseSheet( parser, sheet2, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 3, 3)};
        expectAfCells = new CellObject[] {new CellObject( 6, 9)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "Sheet2", sheet2, true);
        
        // -----------------------
        // [n]IvVwȂ
        // BR-R
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet3 = workbook.getSheetAt( 2);
        
        results = parseSheet( parser, sheet3, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 3, 3)};
        expectAfCells = new CellObject[] {new CellObject( 20, 3)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "Sheet3", sheet3, true);
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-R2
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet4 = workbook.getSheetAt( 3);
        
        results = parseSheet( parser, sheet4, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 3, 3)};
        expectAfCells = new CellObject[] {new CellObject( 24, 3)};
        checkResult( expectBeCells, expectAfCells, results);
        
        checkSheet( "Sheet4", sheet4, true);
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-CR
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet5 = workbook.getSheetAt( 4);
        
        results = parseSheet( parser, sheet5, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 4, 3)};
        expectAfCells = new CellObject[] {new CellObject( 15, 7)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "Sheet5", sheet5, true);
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-BR
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet6 = workbook.getSheetAt( 5);
        
        results = parseSheet( parser, sheet6, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 8, 5), new CellObject( -1, -1), new CellObject( -1, -1)};
        expectAfCells = new CellObject[] {new CellObject( 31, 9), new CellObject( -1, -1), new CellObject( -1, -1)};
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkResult( expectBeCells, expectAfCells, results);
        
        checkSheet( "Sheet6", sheet6, true);
        
        
        // -----------------------
        // [n]IvVwȂ
        // BR-BC
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet7 = workbook.getSheetAt( 6);
        
        results = parseSheet( parser, sheet7, reportsParserInfo);
        
        expectBeCells = new CellObject[] {new CellObject( 8, 5)};
        expectAfCells = new CellObject[] {new CellObject( 22, 16)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "sheet7", sheet7, true);
        
        
        // -----------------------
        // [n]IvVw
        // Ed\
        // E
        // -----------------------
        ReportsParserInfo reportsParserInfo8 = new ReportsParserInfo();
        reportsParserInfo8.setReportParsers( new ArrayList<ReportsTagParser<?>>( ReportCreateHelper.createDefaultParsers().values()));
        reportsParserInfo8.setReportBook( reportBook);
        reportsParserInfo8.setParamInfo( reportSheets[1].getParamInfo());
        
        workbook = getWorkbook();
        Sheet sheet8 = workbook.getSheetAt( 7);
        
        results = parseSheet( parser, sheet8, reportsParserInfo8);
        
        expectBeCells = new CellObject[] {new CellObject( 3, 3)};
        expectAfCells = new CellObject[] {new CellObject( 12, 3)};
        checkResult( expectBeCells, expectAfCells, results);
        
        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "sheet8", sheet8, true);
        
        
        // -----------------------
        // [ُn]`FbN
        // EK{p[^ȂFfromCellȂAtoCellȂ
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet9 = workbook.getSheetAt( 8);
        try {
            results = parseSheet( parser, sheet9, reportsParserInfo);
            fail( "fromCellK{`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet9", sheet9, true);
        
        
        workbook = getWorkbook();
        Sheet sheet10 = workbook.getSheetAt( 9);
        try {
            results = parseSheet( parser, sheet10, reportsParserInfo);
            fail( "toCellK{`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet10", sheet10, true);
        
        
        // -----------------------
        // [ُn]`FbN
        // ElsFfromCellAtoCell
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet11 = workbook.getSheetAt( 10);
        
        try {
            results = parseSheet( parser, sheet11, reportsParserInfo);
            fail( "fromCell̒ľ`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet11", sheet11, true);
        
        workbook = getWorkbook();
        Sheet sheet12 = workbook.getSheetAt( 11);
        
        try {
            results = parseSheet( parser, sheet12, reportsParserInfo);
            fail( "toCell̒ľ`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet12", sheet12, true);
        
        
        
        // -----------------------
        // [ُn]`FbN
        // ElsFfromCellAtoCell
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet13 = workbook.getSheetAt( 12);
        
        try {
            results = parseSheet( parser, sheet13, reportsParserInfo);
            fail( "fromCell̃}CiXl`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet13", sheet13, true);
        
        
        workbook = getWorkbook();
        Sheet sheet14 = workbook.getSheetAt( 13);
        
        try {
            results = parseSheet( parser, sheet14, reportsParserInfo);
            fail( "toCell̃}CiXl`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet14", sheet14, true);
        
        
        // -----------------------
        // [ُn]`FbN
        // ElsFfromCell > toCell
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet15 = workbook.getSheetAt( 14);
        
        try {
            results = parseSheet( parser, sheet15, reportsParserInfo);
            fail( "fromCell > toCell`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet15", sheet15, true);
        
        
        workbook = getWorkbook();
        Sheet sheet17 = workbook.getSheetAt( 16);
        
        try {
            results = parseSheet( parser, sheet17, reportsParserInfo);
            fail( "fromCell > toCell`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet17", sheet17, true);
        
        
        // -----------------------
        // [ُn]`FbN
        // ElsFrepeatNum
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet16 = workbook.getSheetAt( 15);
        
        try {
            results = parseSheet( parser, sheet16, reportsParserInfo);
            fail( "repeatNum̐l`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet16", sheet16, true);
        
        
        workbook = getWorkbook();
        Sheet sheet18 = workbook.getSheetAt( 17);
        
        try {
            results = parseSheet( parser, sheet18, reportsParserInfo);
            fail( "repeatNum̃}CiX`FbNɂĂȂ");
        } catch (ParseException e) {
        }
        checkSheet( "sheet18", sheet18, true);
        
    }
    
    
    /**
     * {@link org.bbreak.excella.reports.tag.BlockRowRepeatParamParser#useControlRow()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testUseControlRow() {
        // -----------------------
        // sgpLF
        // -----------------------
        BlockRowRepeatParamParser parser = new BlockRowRepeatParamParser();
        assertTrue( parser.useControlRow());
    }
    
    
    /**
     * {@link org.bbreak.excella.reports.tag.BlockRowRepeatParamParser#BlockColRepeatParamParser(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testBlockRowRepeatParamParserString() {

        BlockRowRepeatParamParser parser = new BlockRowRepeatParamParser( "Ă");

        assertEquals( "Ă", parser.getTag());
    }
    
    
    private void checkSheet( String expectedSheetName, Sheet actualSheet, boolean outputExcel) {

        // ҒlubN̓ǂݍ
        Workbook expectedWorkbook = getExpectedWorkbook();
        Sheet expectedSheet = expectedWorkbook.getSheet( expectedSheetName);

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, actualSheet, false);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        } finally {
            String tmpDirPath = ReportsTestUtil.getTestOutputDir();
            try {
                String filepath = null;
                Date now = new Date();
                if ( version.equals( "2007")) {
                    filepath = tmpDirPath + this.getClass().getSimpleName() + now.getTime() + ".xlsx";
                } else {
                    filepath = tmpDirPath + this.getClass().getSimpleName() + now.getTime() + ".xls";
                }
                PoiUtil.writeBook( actualSheet.getWorkbook(), filepath);

            } catch ( IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkResult( CellObject[] exceptedBeforeCells, CellObject[] exceptedAfterCells, List<ParsedReportInfo> results) {
        // ʂ̃`FbN
        assertEquals( exceptedAfterCells.length, results.size());

        CellObject[] actualBreforeCells = new CellObject[results.size()];
        CellObject[] actualAfterCells = new CellObject[results.size()];

        for ( int i = 0; i < results.size(); i++) {
            ParsedReportInfo parsedReportInfo = results.get( i);
            // Ol̃`FbN
            actualBreforeCells[i] = new CellObject( parsedReportInfo.getDefaultRowIndex(), parsedReportInfo.getDefaultColumnIndex());
            actualAfterCells[i] = new CellObject( parsedReportInfo.getRowIndex(), parsedReportInfo.getColumnIndex());
        }
        // l̃`FbN
        assertArrayEquals( exceptedBeforeCells, actualBreforeCells);
        assertArrayEquals( exceptedAfterCells, actualAfterCells);

    }

}
