package org.bbreak.excella.reports.samples;

import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Map.Entry;

import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.tag.BlockRowRepeatParamParser;

/**
 * s{bgOtTvo̓NX
 * 
 * @since 1.0
 */
public class PivotGraphReporter {

    /**
     * s{bgOtTv̏o͂s܂B
     * 
     * @param args
     * @throws Exception
     */
    public static void main( String[] args) throws Exception {

        // 
        // @ǂݍރev[gt@C̃pX(gq)
        // Ao͐̃t@CpX(gqExpoterɂĎIɕt^邽߁AsvB)
        // Bt@CtH[}bg(ConvertConfiguration̔z)
        // w肵AReportBookCX^X𐶐܂B
        //
        String templateFileName = "s{bgOtev[g.xls";
        URL templateFileUrl = PivotGraphReporter.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");
        
        // TODO: o͐̃fBNgAyуt@C(gqsv)w肵ĂB
        String outputFileName = "s{bgOtTv";
        String outputFileDir = "C:/work/";
        String outputFilePath = outputFileDir.concat( outputFileName);
        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, ExcelExporter.FORMAT_TYPE);

        //@
        // ev[gt@C̃V[gƏo̓V[gw肵A
        // ReportSheetCX^X𐶐āAReportBookɒǉ܂B
        outputBook.addReportSheet( new ReportSheet( "e[u", "e[u"));
        outputBook.addReportSheet( new ReportSheet( "Ot", "Ot"));
        ReportSheet outputDataSheet = new ReportSheet( "f[^", "f[^");
        outputBook.addReportSheet( outputDataSheet);

        //@
        // up[^ReportSheetIuWFNgɒǉ܂B
        // (ũp[^ɂ͔zn܂B)
        //@
        PivotGraphData[] datas = createRandomPivotGraphDatas();
        outputDataSheet.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "f[^", datas);

        // 
        // ReportProcessorCX^X𐶐A
        // ReportBookɃ|[gs܂B
        // 
        ReportProcessor reportProcessor = new ReportProcessor();
        reportProcessor.process( outputBook);

    }

    /**
     * f[^up[^𐶐܂(ݔŇ猎܂ŁAʁES҃_w)
     * 
     * @return f[^up[^(PivotGraphDataz)Ԃ܂
     */
    @SuppressWarnings( "unused")
    private static PivotGraphData[] createRandomPivotGraphDatas() throws Exception {

        List<PivotGraphData> datas = new ArrayList<PivotGraphData>();
        Random random = new Random();
        String[] salesPersons = new String[] {"̔@", "̔A", "̔B"};

        Calendar calendar = Calendar.getInstance();
        int year = calendar.get( Calendar.YEAR);
        int month = calendar.get( Calendar.MONTH);
        int lastDayOfMonth = calendar.getActualMaximum( Calendar.DAY_OF_MONTH);

        Map<String, BigDecimal> productInfoMap = new LinkedHashMap<String, BigDecimal>();
        productInfoMap.put( "iA", new BigDecimal( 10000));
        productInfoMap.put( "iB", new BigDecimal( 9000));
        productInfoMap.put( "iC", new BigDecimal( 7000));

        for ( int date = 1; date <= lastDayOfMonth; date++) {
            calendar.clear();
            calendar.set( year, month, date);

            for ( Entry<String, BigDecimal> entry : productInfoMap.entrySet()) {
                String productName = entry.getKey();
                BigDecimal unitPrice = entry.getValue();
                BigDecimal quantity = new BigDecimal( random.nextInt( 5) + 2);

                PivotGraphData data = new PivotGraphData();
                data.setSalesDate( calendar.getTime());
                data.setProductName( productName);
                data.setUnitPrice( unitPrice);
                data.setQuantity( quantity);
                data.setPrice( unitPrice.multiply( quantity));
                data.setSalesPerson( salesPersons[random.nextInt( 3)]);
                datas.add( data);
            }
        }

        return datas.toArray( new PivotGraphData[datas.size()]);
    }

}
