/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportSheetTest.java 84 2009-10-30 04:07:19Z akira-yokoi $
 * $Revision: 84 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.model;

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.model.ReportSheet} ̂߂̃eXgENXB
 * 
 * @since 1.0
 */
public class ReportSheetTest {

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#ReportSheet(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testReportSheetStringString() {
        ReportSheet reportSheet = new ReportSheet( "ev[gV[g", "o̓V[g");
        assertEquals( "ev[gV[g", reportSheet.getTemplateName());
        assertEquals( "o̓V[g", reportSheet.getSheetName());

    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#ReportSheet(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testReportSheetString() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        assertEquals( "V[g", reportSheet.getTemplateName());
        assertEquals( "V[g", reportSheet.getSheetName());
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#getTemplateName()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetTemplateName() {
        ReportSheet reportSheet = new ReportSheet( "ev[gV[g", "o̓V[g");
        assertEquals( "ev[gV[g", reportSheet.getTemplateName());
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#getSheetName()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetSheetName() {
        ReportSheet reportSheet = new ReportSheet( "ev[gV[g", "o̓V[g");
        assertEquals( "o̓V[g", reportSheet.getSheetName());
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#setSheetName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testSetSheetName() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        reportSheet.setSheetName( "o̓V[g");
        assertEquals( "o̓V[g", reportSheet.getSheetName());
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#setTemplateName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testSetTemplateName() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        reportSheet.setTemplateName( "ev[gV[g");
        assertEquals( "ev[gV[g", reportSheet.getTemplateName());
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#getParamInfo()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetParamInfo() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);
        reportSheet.addParam( "$A", "testA", "f[^A");

        ParamInfo info = reportSheet.getParamInfo();

        assertEquals( "f[^1", info.getParam( "$", "test1"));
        assertEquals( "f[^2", info.getParam( "$", "test2"));
        assertEquals( "f[^3", info.getParam( "$", "test3"));
        assertEquals( "f[^A", info.getParam( "$A", "testA"));
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#addParam(java.lang.String, java.lang.String, java.lang.Object)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testAddParam() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        reportSheet.addParam( "$", "test", "f[^");

        assertEquals( "f[^", reportSheet.getParam( "$", "test"));
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#addParams(java.lang.String, java.util.Map)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testAddParams() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);

        assertEquals( "f[^1", reportSheet.getParam( "$", "test1"));
        assertEquals( "f[^2", reportSheet.getParam( "$", "test2"));
        assertEquals( "f[^3", reportSheet.getParam( "$", "test3"));
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#clearParam()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testClearParam() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);
        reportSheet.addParam( "$A", "testA", "f[^A");

        reportSheet.clearParam();

        assertNull( reportSheet.getParam( "$", "test1"));
        assertNull( reportSheet.getParam( "$", "test2"));
        assertNull( reportSheet.getParam( "$", "test3"));
        assertNull( reportSheet.getParam( "$A", "testA"));

    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#clearParam(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testClearParamString() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);
        reportSheet.addParam( "$A", "testA", "f[^A");

        reportSheet.clearParam( "$");
        assertNull( reportSheet.getParam( "$", "test1"));
        assertNull( reportSheet.getParam( "$", "test2"));
        assertNull( reportSheet.getParam( "$", "test3"));

        assertEquals( "f[^A", reportSheet.getParam( "$A", "testA"));
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#getParam(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetParam() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);
        reportSheet.addParam( "$A", "testA", "f[^A");

        assertEquals( "f[^1", reportSheet.getParam( "$", "test1"));
        assertEquals( "f[^2", reportSheet.getParam( "$", "test2"));
        assertEquals( "f[^3", reportSheet.getParam( "$", "test3"));
        assertEquals( "f[^A", reportSheet.getParam( "$A", "testA"));
    }

    /**
     * {@link org.bbreak.excella.reports.model.ReportSheet#removeParam(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testRemoveParam() {
        ReportSheet reportSheet = new ReportSheet( "V[g");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put( "test1", "f[^1");
        map.put( "test2", "f[^2");
        map.put( "test3", "f[^3");
        reportSheet.addParams( "$", map);
        reportSheet.addParam( "$A", "testA", "f[^A");

        reportSheet.removeParam( "$", "test2");
        reportSheet.removeParam( "$A", "testA");

        assertEquals( "f[^1", reportSheet.getParam( "$", "test1"));
        assertNull( reportSheet.getParam( "$", "test2"));
        assertEquals( "f[^3", reportSheet.getParam( "$", "test3"));
        assertNull( reportSheet.getParam( "$A", "testA"));
    }

}
