/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: RowRepeatParamParserTest.java 191 2010-08-17 18:30:16Z ogiharasf $
 * $Revision: 191 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

package org.bbreak.excella.reports.tag;

import static org.junit.Assert.*;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.model.ConvertConfiguration;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.CellObject;
import org.bbreak.excella.reports.processor.ReportCreateHelper;
import org.bbreak.excella.reports.processor.ReportsCheckException;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.processor.ReportsWorkbookTest;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.tag.RowRepeatParamParser} ̂߂̃eXgENXB
 * 
 * @since 1.0
 */
public class RowRepeatParamParserTest extends ReportsWorkbookTest {

    public RowRepeatParamParserTest( String version) {
        super( version);
    }

    /**
     * {@link org.bbreak.excella.reports.tag.RowRepeatParamParser#parse(org.apache.poi.ss.usermodel.Sheet, org.apache.poi.ss.usermodel.Cell, java.lang.Object)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testParseSheetCellObject() {

        Workbook workbook = getWorkbook();
        Sheet sheet1 = workbook.getSheetAt( 0);

        // -----------------------
        // [n]IvVwȂ
        // -----------------------

        ReportBook reportBook = new ReportBook("",  "test", new ConvertConfiguration[] {});
//        reportBook.setCopyTemplate( true);
        ReportSheet reportSheet1 = new ReportSheet( "sheet1", "Sheet1");
        reportBook.addReportSheet( reportSheet1);
        ReportSheet reportSheet2 = new ReportSheet( "sheet1", "Sheet2");
        reportBook.addReportSheet( reportSheet2);
        ReportSheet reportSheet3 = new ReportSheet( "sheet1", "Sheet3");
        reportBook.addReportSheet( reportSheet3);

        ReportSheet[] reportSheets = new ReportSheet[] {reportSheet1, reportSheet2, reportSheet3};

        for ( ReportSheet reportSheet : reportSheets) {
            ParamInfo info = reportSheet.getParamInfo();
            info.addParam( "$R[]", "A", new Object[] {"AA1", "AA1", "AA2", "AA2", "AA3"});
            info.addParam( "$R[]", "B", new Object[] {"BB1", "BB1", "BB2"});
            info.addParam( "$R[]", "C", new Object[] {"CC1", "CC2", "CC3", "CC4", "CC5"});
            info.addParam( "$", "D", "DDD");
        }

        RowRepeatParamParser parser = new RowRepeatParamParser();
        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setReportParsers( new ArrayList<ReportsTagParser<?>>( ReportCreateHelper.createDefaultParsers().values()));
        reportsParserInfo.setReportBook( reportBook);
        reportsParserInfo.setParamInfo( reportSheets[0].getParamInfo());

        // ͏.
        List<ParsedReportInfo> results = null;
        try {
            results = parseSheet( parser, sheet1, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }

        CellObject[] expectBeCells = new CellObject[] {new CellObject( 0, 0), new CellObject( 2, 1)};
        CellObject[] expectAfCells = new CellObject[] {new CellObject( 4, 0), new CellObject( 4, 1)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }

        checkSheet( "Sheet1", sheet1, true);

        // -----------------------
        // [n]IvVw
        // Esy[W
        // ElύXy[W
        // Ed\
        // E
        // EZVtg
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet2 = workbook.getSheetAt( 1);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet2, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }

        expectBeCells = new CellObject[] {new CellObject( 0, 0), new CellObject( 2, 1), new CellObject( 4, 2)};
        expectAfCells = new CellObject[] {new CellObject( 4, 0), new CellObject( 4, 1), new CellObject( 5, 2)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        checkSheet( "Sheet2", sheet2, true);

        // -----------------------
        // [n]IvVw
        // EV[gN
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet3 = workbook.getSheetAt( 2);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet3, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }

        expectBeCells = new CellObject[] {new CellObject( 0, 0), new CellObject( 0, 1), new CellObject( 0, 2), new CellObject( 17, 1), new CellObject( 18, 0)};
        expectAfCells = new CellObject[] {new CellObject( 2, 0), new CellObject( 1, 1), new CellObject( 4, 2), new CellObject( 19, 1), new CellObject( 20, 0)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        checkSheet( "Sheet3", sheet3, true);

        // -----------------------
        // [ُn]`FbN
        // EV[gnCp[NݒLƏd\͏ds
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet4 = workbook.getSheetAt( 3);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet4, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }

        expectBeCells = new CellObject[] {new CellObject( 0, 0), new CellObject( 1, 0), new CellObject( 2, 0)};
        expectAfCells = new CellObject[] {new CellObject( 0, 0), new CellObject( 1, 0), new CellObject( 2, 0)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        checkSheet( "Sheet4", sheet4, true);

        Sheet sheet5 = workbook.getSheetAt( 4);
        // ͏
        try {
            parseSheet( parser, sheet5, reportsParserInfo);
            fail( "V[gnCp[NݒLƏd\͏ds`FbNɂĂȂ");
        } catch ( ParseException e) {
        }

        // -----------------------
        // [ُn]`FbN
        // EG[ꍇ
        // -----------------------
        workbook = getWorkbook();
        Sheet sheet6 = workbook.getSheetAt( 5);
        // ͏
        try {
            parseSheet( parser, sheet6, reportsParserInfo);
            fail();
        } catch ( ParseException e) {
            assertTrue( e instanceof ParseException);
        }
        
        // ------------------------------------------------------------
        // [ُn]
        // Eɗ̌Z݂ꍇ
        //   PoiUtil.getMergedAddress\bhɂ
        //   `zO邱Ƃ̊mFs
        // ------------------------------------------------------------
        workbook = getWorkbook();
        Sheet sheet7 = workbook.getSheetAt( 6);
        // ͏
        try {
            results = parseSheet( parser, sheet7, reportsParserInfo);
            fail( "zO");
        } catch ( ParseException e) {
            // org.bbreak.excella.core.util.PoiUtil#getMergedAddress( Sheet sheet, CellRangeAddress rangeAddress)
            // throwzOł邱ƂmF
            assertTrue( e.getCause() instanceof IllegalArgumentException);
            assertTrue( e.getMessage().contains("There are crossing merged regions in the range."));
        }
        
        // ------------------------------------------------------------
        // [n]
        // EšZiTCYQj݂ꍇ̐ImF
        // ------------------------------------------------------------
        workbook = getWorkbook();
        Sheet sheet8 = workbook.getSheetAt( 7);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet8, reportsParserInfo);
        } catch ( ParseException e) {
            e.printStackTrace();
            fail( e.toString());
        }
        
        expectBeCells = new CellObject[] {new CellObject(2,0), new CellObject(2,1), new CellObject(2,2), new CellObject(2,3), new CellObject(2,4), new CellObject(14,0)};
        expectAfCells = new CellObject[] {new CellObject(10,0), new CellObject(10,1), new CellObject(10,2), new CellObject(4,3), new CellObject(6,4), new CellObject(22,0)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        checkSheet( "Sheet8", sheet8, true);
        
        // ------------------------------------------------------------
        // [n]
        // EšZiTCYRj݂ꍇ̐ImF
        // ------------------------------------------------------------
        workbook = getWorkbook();
        Sheet sheet9 = workbook.getSheetAt( 8);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet9, reportsParserInfo);
        } catch ( ParseException e) {
            e.printStackTrace();
            fail( e.toString());
        }
        
        expectBeCells = new CellObject[] {new CellObject(3,0),new CellObject(3,1),new CellObject(3,2),new CellObject(3,3),new CellObject(3,4)};
        expectAfCells = new CellObject[] {new CellObject(15,0),new CellObject(15,1),new CellObject(15,2),new CellObject(6,3),new CellObject(9,4)};
        checkResult( expectBeCells, expectAfCells, results);

        // svV[g폜
        if ( version.equals( "2007")) {
            int index = workbook.getSheetIndex( PoiUtil.TMP_SHEET_NAME);
            if ( index > 0) {
                workbook.removeSheetAt( index);
            }
        }
        
        checkSheet( "Sheet9", sheet9, true);
        
        
        // ------------------------------------------------------------
        // [ُn]
        // E^OZšZłꍇɂ
        //   PoiUtil.getMergedAddress\bhɂ
        //   `zO邱Ƃ̊mFs
        // ------------------------------------------------------------
        workbook = getWorkbook();
        Sheet sheet10 = workbook.getSheetAt( 9);
        // ͏
        results = null;
        try {
            results = parseSheet( parser, sheet10, reportsParserInfo);
            fail( "zO");
        } catch ( ParseException e) {
            // org.bbreak.excella.core.util.PoiUtil#getMergedAddress( Sheet sheet, CellRangeAddress rangeAddress)
            // throwzOł邱ƂmF
            assertTrue( e.getCause() instanceof IllegalArgumentException);
            assertTrue( e.getMessage().contains("There are crossing merged regions in the range."));
        }
        
    }

    /**
     * {@link org.bbreak.excella.reports.tag.RowRepeatParamParser#useControlRow()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testUseControlRow() {
        // -----------------------
        // sgpLF
        // -----------------------
        RowRepeatParamParser parser = new RowRepeatParamParser();
        assertFalse( parser.useControlRow());
    }

    /**
     * {@link org.bbreak.excella.reports.tag.RowRepeatParamParser#RowRepeatParamParser(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testRowRepeatParamParserString() {

        RowRepeatParamParser parser = new RowRepeatParamParser( "Ă");

        assertEquals( "Ă", parser.getTag());
    }

    private void checkSheet( String expectedSheetName, Sheet actualSheet, boolean outputExcel) {

        // ҒlubN̓ǂݍ
        Workbook expectedWorkbook = getExpectedWorkbook();
        Sheet expectedSheet = expectedWorkbook.getSheet( expectedSheetName);

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, actualSheet, false);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        } finally {
            String tmpDirPath = ReportsTestUtil.getTestOutputDir();
            try {
                String filepath = null;
                Date now = new Date();
                if ( version.equals( "2007")) {
                    filepath = tmpDirPath + this.getClass().getSimpleName() + now.getTime() + ".xlsx";
                } else {
                    filepath = tmpDirPath + this.getClass().getSimpleName() + now.getTime() + ".xls";
                }
                PoiUtil.writeBook( actualSheet.getWorkbook(), filepath);

            } catch ( IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkResult( CellObject[] exceptedBeforeCells, CellObject[] exceptedAfterCells, List<ParsedReportInfo> results) {
        // ʂ̃`FbN
        assertEquals( exceptedAfterCells.length, results.size());

        CellObject[] actualBreforeCells = new CellObject[results.size()];
        CellObject[] actualAfterCells = new CellObject[results.size()];

        for ( int i = 0; i < results.size(); i++) {
            ParsedReportInfo parsedReportInfo = results.get( i);
            // Ol̃`FbN
            actualBreforeCells[i] = new CellObject( parsedReportInfo.getDefaultRowIndex(), parsedReportInfo.getDefaultColumnIndex());
            actualAfterCells[i] = new CellObject( parsedReportInfo.getRowIndex(), parsedReportInfo.getColumnIndex());
        }
        // l̃`FbN
        assertArrayEquals( exceptedBeforeCells, actualBreforeCells);
        assertArrayEquals( exceptedAfterCells, actualAfterCells);

    }
  
}
