/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CmdLineLogMessage
extends CmdLineXmlCommand
implements ISVNLogMessage {
    private SVNRevision.Number rev;
    private String author;
    private Date date;
    private String msg;
    private ISVNLogMessageChangePath[] logMessageChangePaths;

    CmdLineLogMessage(SVNRevision.Number rev, String author, Date date, String msg, ISVNLogMessageChangePath[] logMessageChangePaths) {
        this.rev = rev;
        this.author = author;
        this.date = date;
        this.msg = msg;
        this.logMessageChangePaths = logMessageChangePaths;
    }

    CmdLineLogMessage(StringTokenizer st) {
        String headerLine = st.nextToken();
        StringTokenizer ltr = new StringTokenizer(headerLine, "|");
        String left = ltr.nextToken();
        String middle = ltr.nextToken();
        String right = ltr.nextToken();
        StringTokenizer leftToken = new StringTokenizer(left, ":");
        String revStr = leftToken.nextToken().trim();
        this.rev = Helper.toRevNum(revStr.substring(4, revStr.length()));
        this.author = leftToken.hasMoreTokens() ? leftToken.nextToken() : "";
        this.date = Helper.toDate(middle.trim());
        StringTokenizer rightToken = new StringTokenizer(right, " ");
        int messageLineCount = Integer.parseInt(rightToken.nextToken());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < messageLineCount; ++i) {
            sb.append(st.nextToken());
            if (i >= messageLineCount - 1) continue;
            sb.append('\n');
        }
        this.msg = sb.toString();
        st.nextToken();
    }

    public SVNRevision.Number getRevision() {
        return this.rev;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.msg;
    }

    public String toString() {
        return this.getMessage();
    }

    public static CmdLineLogMessage[] createLogMessages(byte[] cmdLineResults) throws SVNClientException {
        ArrayList<CmdLineLogMessage> logMessages = new ArrayList<CmdLineLogMessage>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            InputSource source = new InputSource(new ByteArrayInputStream(cmdLineResults));
            Document doc = factory.newDocumentBuilder().parse(source);
            NodeList nodes = doc.getElementsByTagName("logentry");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node logEntry = nodes.item(i);
                Element authorNode = CmdLineLogMessage.getFirstNamedElement(logEntry, "author");
                Element dateNode = authorNode == null ? CmdLineLogMessage.getFirstNamedElement(logEntry, "date") : CmdLineLogMessage.getNextNamedElement(authorNode, "date");
                if (dateNode == null) {
                    throw new Exception("'date' tag expected under 'logentry'");
                }
                Element pathsNode = CmdLineLogMessage.getNextNamedElement(dateNode, "paths");
                Element msgNode = CmdLineLogMessage.getNextNamedElement(pathsNode != null ? pathsNode : dateNode, "msg");
                Node revisionAttribute = logEntry.getAttributes().getNamedItem("revision");
                SVNRevision.Number rev = revisionAttribute != null ? Helper.toRevNum(revisionAttribute.getNodeValue()) : null;
                String author = authorNode != null ? authorNode.getFirstChild().getNodeValue() : "";
                Date date = Helper.convertXMLDate(dateNode.getFirstChild().getNodeValue());
                Node msgTextNode = msgNode.getFirstChild();
                String msg = msgTextNode != null ? msgTextNode.getNodeValue() : "";
                ArrayList<SVNLogMessageChangePath> paths = new ArrayList<SVNLogMessageChangePath>();
                Element pathNode = CmdLineLogMessage.getFirstNamedElement(pathsNode, "path");
                while (pathNode != null) {
                    String path = pathNode.getFirstChild().getNodeValue();
                    NamedNodeMap attributes = pathNode.getAttributes();
                    char action = attributes.getNamedItem("action").getNodeValue().charAt(0);
                    Node copyFromPathNode = attributes.getNamedItem("copyfrom-path");
                    Node copyFromRevNode = attributes.getNamedItem("copyfrom-rev");
                    String copyFromPath = null;
                    if (copyFromPathNode != null) {
                        copyFromPath = copyFromPathNode.getNodeValue();
                    }
                    SVNRevision.Number copyFromRev = null;
                    if (copyFromRevNode != null) {
                        copyFromRev = Helper.toRevNum(copyFromRevNode.getNodeValue());
                    }
                    paths.add(new SVNLogMessageChangePath(path, copyFromRev, copyFromPath, action));
                    pathNode = CmdLineLogMessage.getNextNamedElement(pathNode, "path");
                }
                ISVNLogMessageChangePath[] logMessageChangePath = paths.toArray(new ISVNLogMessageChangePath[paths.size()]);
                CmdLineLogMessage logMessage = new CmdLineLogMessage(rev, author, date, msg, logMessageChangePath);
                logMessages.add(logMessage);
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        return logMessages.toArray(new CmdLineLogMessage[logMessages.size()]);
    }

    public ISVNLogMessageChangePath[] getChangedPaths() {
        return this.logMessageChangePaths;
    }

    public ISVNLogMessage[] getChildMessages() {
        return null;
    }

    public long getNumberOfChildren() {
        return 0L;
    }

    public long getTimeMicros() {
        return 0L;
    }

    public long getTimeMillis() {
        return 0L;
    }

    public void addChild(ISVNLogMessage msg) {
    }

    public boolean hasChildren() {
        return false;
    }
}

