/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineInfoPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusComposite;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;

public class CmdLineStatuses {
    private CmdLineInfoPart[] cmdLineInfoParts;
    private CmdLineStatusPart[] cmdLineStatusParts;
    private ISVNStatus[] cmdLineStatuses;

    CmdLineStatuses(String infoLines, CmdLineStatusPart[] cmdLineStatusParts) {
        this.cmdLineStatusParts = cmdLineStatusParts;
        if (infoLines.length() == 0) {
            this.cmdLineInfoParts = new CmdLineInfoPart[0];
        } else {
            String[] parts = CmdLineInfoPart.parseInfoParts(infoLines);
            this.cmdLineInfoParts = new CmdLineInfoPart[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                this.cmdLineInfoParts[i] = new CmdLineInfoPart(parts[i]);
            }
        }
        this.cmdLineStatuses = this.buildStatuses();
    }

    CmdLineStatuses(CmdLineInfoPart[] cmdLineInfoParts, CmdLineStatusPart[] cmdLineStatusParts) {
        this.cmdLineInfoParts = cmdLineInfoParts;
        this.cmdLineStatusParts = cmdLineStatusParts;
        this.cmdLineStatuses = this.buildStatuses();
    }

    private ISVNStatus[] buildStatuses() {
        this.processExternalStatuses(this.cmdLineStatusParts);
        LinkedList<ISVNStatus> statuses = new LinkedList<ISVNStatus>();
        for (int i = 0; i < this.cmdLineStatusParts.length; ++i) {
            CmdLineStatusPart cmdLineStatusPart = this.cmdLineStatusParts[i];
            File absPath = cmdLineStatusPart.getFile();
            if (cmdLineStatusPart == null || !cmdLineStatusPart.isManaged()) {
                boolean isIgnored = false;
                if (cmdLineStatusPart != null) {
                    isIgnored = SVNStatusKind.IGNORED.equals(cmdLineStatusPart.getTextStatus());
                }
                statuses.add(new SVNStatusUnversioned(absPath, isIgnored));
                continue;
            }
            CmdLineInfoPart cmdLineInfoPart = this.getCorrespondingInfoPart(absPath);
            if (cmdLineInfoPart == null) continue;
            statuses.add(new CmdLineStatusComposite(cmdLineStatusPart, cmdLineInfoPart));
        }
        return statuses.toArray(new ISVNStatus[statuses.size()]);
    }

    private CmdLineInfoPart getCorrespondingInfoPart(File absPath) {
        for (int i = 0; i < this.cmdLineInfoParts.length; ++i) {
            if (!absPath.equals(this.cmdLineInfoParts[i].getFile())) continue;
            return this.cmdLineInfoParts[i];
        }
        return null;
    }

    protected CmdLineStatusPart[] processExternalStatuses(CmdLineStatusPart[] statuses) {
        ArrayList<Integer> externalStatusesIndexes = new ArrayList<Integer>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!SVNStatusKind.EXTERNAL.equals(statuses[i].getTextStatus())) continue;
            externalStatusesIndexes.add(new Integer(i));
        }
        if (externalStatusesIndexes.isEmpty()) {
            return statuses;
        }
        Iterator iter = externalStatusesIndexes.iterator();
        while (iter.hasNext()) {
            int index = (Integer)iter.next();
            CmdLineStatusPart aStatus = statuses[index];
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getPath() == null || !statuses[i].getPath().equals(aStatus.getPath())) continue;
                statuses[i].setTextStatus(SVNStatusKind.EXTERNAL);
            }
        }
        return statuses;
    }

    public ISVNStatus get(int i) {
        return this.cmdLineStatuses[i];
    }

    public int size() {
        return this.cmdLineStatuses.length;
    }

    public ISVNStatus[] toArray() {
        return this.cmdLineStatuses;
    }
}

