/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.InputStream;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotify;
import org.tigris.subversion.svnclientadapter.commandline.CommandLine;
import org.tigris.subversion.svnclientadapter.commandline.parser.SvnOutputParser;

public class SvnCommandLine
extends CommandLine {
    protected String user;
    protected String pass;
    protected SvnOutputParser svnOutputParser = new SvnOutputParser();
    protected long rev = -1L;
    protected boolean parseSvnOutput = false;
    protected String configDir = null;

    SvnCommandLine(String svnPath, CmdLineNotificationHandler notificationHandler) {
        super(svnPath, notificationHandler);
    }

    protected static String validRev(String revision) {
        return revision == null || "".equals(revision) ? "HEAD" : revision;
    }

    void setUsername(String username) {
        this.user = username;
    }

    void setPassword(String password) {
        this.pass = password;
    }

    void setConfigDirectory(String dir) {
        this.configDir = dir;
    }

    String version() throws CmdLineException {
        this.setCommand(0, false);
        return super.version();
    }

    String add(String path, boolean recursive, boolean force) throws CmdLineException {
        this.setCommand(1, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("add");
        if (!recursive) {
            args.add("-N");
        }
        if (force) {
            args.add("--force");
        }
        args.add(path);
        return this.execString(args, false);
    }

    InputStream cat(String url, String revision) throws CmdLineException {
        this.setCommand(18, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("cat");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    String checkin(String[] path, String message, boolean keepLocks) throws CmdLineException {
        this.setCommand(3, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("ci");
        if (keepLocks) {
            args.add("--no-unlock");
        }
        args.addLogMessage(message);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < path.length; ++i) {
            args.add(path[i]);
        }
        return this.execString(args, false);
    }

    void cleanup(String path) throws CmdLineException {
        this.setCommand(24, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("cleanup");
        args.add(path);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String checkout(String url, String destination, String revision, boolean recursive) throws CmdLineException {
        this.setCommand(2, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("co");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url + "@" + SvnCommandLine.validRev(revision));
        args.add(destination);
        if (!recursive) {
            args.add("-N");
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void copy(String src, String dest, String message, String revision) throws CmdLineException {
        this.setCommand(6, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("cp");
        if (revision != null) {
            args.add("-r");
            args.add(SvnCommandLine.validRev(revision));
        }
        if (message != null) {
            args.addLogMessage(message);
        }
        args.add(src);
        args.add(dest);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void copy(String src, String dest) throws CmdLineException {
        this.setCommand(6, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("cp");
        args.add(src);
        args.add(dest);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String delete(String[] target, String message, boolean force) throws CmdLineException {
        this.setCommand(7, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("rm");
        if (message != null) {
            args.addLogMessage(message);
        }
        if (force) {
            args.add("--force");
        }
        for (int i = 0; i < target.length; ++i) {
            args.add(target[i]);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    InputStream diff(String oldPath, String oldRev, String newPath, String newRev, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws CmdLineException {
        this.setCommand(17, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("diff");
        if (newRev != null) {
            args.add("-r");
            if (newRev.equals("WORKING")) {
                args.add(oldRev);
            } else {
                args.add(oldRev + ":" + newRev);
            }
        }
        if (!recurse) {
            args.add("-N");
        }
        if (!ignoreAncestry) {
            args.add("--notice-ancestry");
        }
        if (noDiffDeleted) {
            args.add("--no-diff-deleted");
        }
        if (force) {
            args.add("--force");
        }
        args.add("--old");
        args.add(oldPath);
        args.add("--new");
        args.add(newPath);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    void export(String url, String path, String revision, boolean force) throws CmdLineException {
        this.setCommand(8, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("export");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url);
        args.add(path);
        if (force) {
            args.add("--force");
        }
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String importFiles(String path, String url, String message, boolean recursive) throws CmdLineException {
        this.setCommand(9, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("import");
        args.add(path);
        args.add(url);
        if (!recursive) {
            args.add("-N");
        }
        args.addLogMessage(message);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String info(String[] target, String revision, String peg) throws CmdLineException {
        if (target.length == 0) {
            return "";
        }
        this.setCommand(19, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("info");
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        if (revision != null) {
            args.add("-r");
            args.add(revision);
        }
        for (int i = 0; i < target.length; ++i) {
            if (peg == null) {
                args.add(target[i]);
                continue;
            }
            args.add(target[i] + "@" + peg);
        }
        return this.execString(args, false);
    }

    byte[] list(String url, String revision, boolean recursive) throws CmdLineException {
        this.setCommand(11, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("list");
        if (recursive) {
            args.add("-R");
        }
        args.add("--xml");
        args.add("-r");
        args.add(revision);
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    byte[] log(String target, String revision, boolean stopOnCopy, long limit) throws CmdLineException {
        this.setCommand(13, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("log");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(target);
        args.add("--xml");
        if (stopOnCopy) {
            args.add("--stop-on-copy");
        }
        if (limit > 0L) {
            args.add("--limit");
            args.add(Long.toString(limit));
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, true);
    }

    byte[] logVerbose(String target, String[] paths, String revision, boolean stopOnCopy, long limit) throws CmdLineException {
        this.setCommand(13, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("log");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(target);
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                args.add(paths[i]);
            }
        }
        args.add("--xml");
        args.add("-v");
        if (stopOnCopy) {
            args.add("--stop-on-copy");
        }
        if (limit > 0L) {
            args.add("--limit");
            args.add(Long.toString(limit));
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, true);
    }

    void mkdir(String url, String message) throws CmdLineException {
        this.setCommand(10, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("mkdir");
        args.addLogMessage(message);
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void mkdir(String localPath) throws CmdLineException {
        this.setCommand(10, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("mkdir");
        args.add(localPath);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String move(String source, String dest, String message, String revision, boolean force) throws CmdLineException {
        this.setCommand(5, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("mv");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(source);
        args.add(dest);
        if (message != null) {
            args.addLogMessage(message);
        }
        if (force) {
            args.add("--force");
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    InputStream propget(String path, String propName) throws CmdLineException {
        this.setCommand(20, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propget");
        args.add("--strict");
        args.add(propName);
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    InputStream propget(String path, String propName, String revision, String peg) throws CmdLineException {
        this.setCommand(20, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propget");
        args.add("--strict");
        args.add("-r");
        args.add(revision);
        args.add(propName);
        args.add(path + "@" + peg);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    void propset(String propName, String propValue, String target, boolean recurse) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propset");
        if (recurse) {
            args.add("-R");
        }
        args.add(propName);
        args.add(propValue);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String proplist(String target, boolean recurse) throws CmdLineException {
        this.setCommand(21, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("proplist");
        if (recurse) {
            args.add("-R");
        }
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void propdel(String propName, String target, boolean recurse) throws CmdLineException {
        this.setCommand(15, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propdel");
        if (recurse) {
            args.add("-R");
        }
        args.add(propName);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void propsetFile(String propName, String propFile, String target, boolean recurse) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propset");
        if (recurse) {
            args.add("-R");
        }
        args.add(propName);
        args.add("-F");
        args.add(propFile);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String revert(String[] paths, boolean recursive) throws CmdLineException {
        this.setCommand(16, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("revert");
        if (recursive) {
            args.add("-R");
        }
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void resolved(String[] paths, boolean recursive) throws CmdLineException {
        this.setCommand(22, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("resolved");
        if (recursive) {
            args.add("-R");
        }
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    byte[] status(String[] path, boolean descend, boolean allEntries, boolean checkUpdates, boolean ignoreExternals) throws CmdLineException {
        if (path.length == 0) {
            return new byte[0];
        }
        this.setCommand(12, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("status");
        args.add("--xml");
        if (allEntries) {
            args.add("-v");
        }
        if (!descend) {
            args.add("-N");
        }
        if (checkUpdates) {
            args.add("-u");
        }
        if (allEntries) {
            args.add("--no-ignore");
        }
        if (ignoreExternals) {
            args.add("--ignore-externals");
        }
        for (int i = 0; i < path.length; ++i) {
            args.add(path[i]);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    String update(String path, String revision) throws CmdLineException {
        this.setCommand(4, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("up");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String update(String[] paths, String revision) throws CmdLineException {
        StringBuffer pathsArg = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            pathsArg.append(paths[i]);
            pathsArg.append(" ");
        }
        this.setCommand(4, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("up");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(pathsArg.toString());
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    byte[] annotate(String path, String revisionStart, String revisionEnd) throws CmdLineException {
        this.setCommand(25, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("annotate");
        args.add("--xml");
        args.add("-r");
        if (revisionStart != null && revisionStart.length() > 0) {
            args.add(SvnCommandLine.validRev(revisionStart) + ":" + SvnCommandLine.validRev(revisionEnd));
        } else {
            args.add(SvnCommandLine.validRev(revisionEnd));
        }
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    String switchUrl(String path, String url, String revision, boolean recurse) throws CmdLineException {
        this.setCommand(26, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("sw");
        args.add(url);
        args.add(path);
        if (!recurse) {
            args.add("-N");
        }
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String relocate(String from, String to, String path, boolean recurse) throws CmdLineException {
        this.setCommand(30, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("sw");
        args.add("--relocate");
        if (!recurse) {
            args.add("-N");
        }
        args.add(from);
        args.add(to);
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String merge(String path1, String revision1, String path2, String revision2, String localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws CmdLineException {
        this.setCommand(27, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("merge");
        if (!recurse) {
            args.add("-N");
        }
        if (force) {
            args.add("--force");
        }
        if (ignoreAncestry) {
            args.add("--ignore-ancestry");
        }
        if (dryRun) {
            args.add("--dry-run");
        }
        if (path1.equals(path2)) {
            args.add("-r");
            args.add(SvnCommandLine.validRev(revision1) + ":" + SvnCommandLine.validRev(revision2));
            args.add(path1);
        } else {
            args.add(path1 + "@" + SvnCommandLine.validRev(revision1));
            args.add(path2 + "@" + SvnCommandLine.validRev(revision2));
        }
        args.add(localPath);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void revpropset(String propName, String propValue, String target, String revision, boolean force) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("propset");
        args.add(propName);
        args.add("--revprop");
        args.add(propValue);
        args.add(target);
        args.add("-r");
        args.add(revision);
        if (force) {
            args.add("--force");
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String lock(Object[] paths, String comment, boolean force) throws CmdLineException {
        this.setCommand(28, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("lock");
        if (force) {
            args.add("--force");
        }
        if (comment != null && !comment.equals("")) {
            args.add("-m");
            args.add(comment);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        return this.execString(args, false);
    }

    String unlock(Object[] paths, boolean force) throws CmdLineException {
        this.setCommand(29, true);
        CommandLine.CmdArguments args = new CommandLine.CmdArguments();
        args.add("unlock");
        if (force) {
            args.add("--force");
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        return this.execString(args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFromSvnOutput(String svnOutput) {
        this.rev = -1L;
        super.notifyFromSvnOutput(svnOutput);
        if (this.parseSvnOutput) {
            CmdLineNotify notify = new CmdLineNotify(){

                public void onNotify(String path, int action, int kind, String mimeType, int contentState, int propState, long revision) {
                    if (path != null) {
                        SvnCommandLine.this.notificationHandler.notifyListenersOfChange(path);
                    }
                    if (revision != -1L) {
                        SvnCommandLine.this.rev = revision;
                        SvnCommandLine.this.notificationHandler.logRevision(revision, path);
                    }
                }
            };
            try {
                this.svnOutputParser.addListener(notify);
                this.svnOutputParser.parse(svnOutput);
            }
            finally {
                this.svnOutputParser.removeListener(notify);
            }
        }
    }

    protected void notifyMessagesFromSvnOutput(String svnOutput) {
        this.rev = -1L;
        super.notifyFromSvnOutput(svnOutput);
    }

    protected void setCommand(int command, boolean ouputIsNotification) {
        this.parseSvnOutput = ouputIsNotification;
        this.notificationHandler.setCommand(command);
    }

    public long getRevision() {
        return this.rev;
    }
}

