/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.atp.AnalysisToolPak;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NameEval;
import org.apache.poi.hssf.record.formula.eval.NameXEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.eval.NotImplementedException;

final class ExternalFunction
implements FreeRefFunction {
    ExternalFunction() {
    }

    public ValueEval evaluate(Eval[] args, EvaluationWorkbook workbook, int srcCellSheet, int srcCellRow, int srcCellCol) {
        FreeRefFunction targetFunc;
        int nIncomingArgs = args.length;
        if (nIncomingArgs < 1) {
            throw new RuntimeException("function name argument missing");
        }
        Eval nameArg = args[0];
        if (nameArg instanceof NameEval) {
            targetFunc = ExternalFunction.findInternalUserDefinedFunction((NameEval)nameArg);
        } else if (nameArg instanceof NameXEval) {
            targetFunc = ExternalFunction.findExternalUserDefinedFunction(workbook, (NameXEval)nameArg);
        } else {
            throw new RuntimeException("First argument should be a NameEval, but got (" + nameArg.getClass().getName() + ")");
        }
        int nOutGoingArgs = nIncomingArgs - 1;
        Eval[] outGoingArgs = new Eval[nOutGoingArgs];
        System.arraycopy(args, 1, outGoingArgs, 0, nOutGoingArgs);
        return targetFunc.evaluate(outGoingArgs, workbook, srcCellSheet, srcCellRow, srcCellCol);
    }

    private static FreeRefFunction findExternalUserDefinedFunction(EvaluationWorkbook workbook, NameXEval n) {
        String functionName = workbook.resolveNameXText(n.getPtg());
        FreeRefFunction result = AnalysisToolPak.findFunction(functionName);
        if (result != null) {
            return result;
        }
        throw new NotImplementedException(functionName);
    }

    private static FreeRefFunction findInternalUserDefinedFunction(NameEval functionNameEval) {
        String functionName = functionNameEval.getFunctionName();
        throw new NotImplementedException(functionName);
    }
}

