/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: RowRepeatParamParser.java 198 2011-08-16 01:59:02Z tomo-shibata $
 * $Revision: 198 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.util.ReportsUtil;

/**
 * V[g̍sJԂuϊp[T
 * 
 * @since 1.0
 */
public class RowRepeatParamParser extends ReportsTagParser<Object[]> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( RowRepeatParamParser.class);

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$R[]";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * d\̒p[^
     */
    protected static final String PARAM_DUPLICATE = "hideDuplicate";

    /**
     * l̑}@p[^
     */
    public static final String PARAM_ROW_SHIFT = "rowShift";

    /**
     * y[Wf[^
     */
    public static final String PARAM_BREAK_NUM = "breakNum";

    /**
     * lύXł̉y[WLp[^
     */
    public static final String PARAM_CHANGE_BREAK = "changeBreak";

    /**
     * JԂő
     */
    public static final String PARAM_REPEAT_NUM = "repeatNum";

    /**
     * V[gւ̃nCp[NݒL
     */
    public static final String PARAM_SHEET_LINK = "sheetLink";

    /**
     * V[gϐ̕ϐ
     */
    public static final String PARAM_PROPERTY = "property";

    /**
     * RXgN^
     */
    public RowRepeatParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public RowRepeatParamParser( String tag) {
        super( tag);
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

        // p[^`FbN
        checkParam( paramDef, tagCell);

        String tag = tagCell.getStringCellValue();
        ReportsParserInfo reportsParserInfo = ( ReportsParserInfo) data;
        // u
        Object[] paramValues = null;
        try {
            // l̑}@
            boolean rowShift = false;
            if ( paramDef.containsKey( PARAM_ROW_SHIFT)) {
                rowShift = Boolean.valueOf( paramDef.get( PARAM_ROW_SHIFT));
            }
            // d\
            boolean hideDuplicate = false;
            if ( paramDef.containsKey( PARAM_DUPLICATE)) {
                hideDuplicate = Boolean.valueOf( paramDef.get( PARAM_DUPLICATE));
            }
            // y[Wf[^
            Integer breakNum = null;
            if ( paramDef.containsKey( PARAM_BREAK_NUM)) {
                breakNum = Integer.valueOf( paramDef.get( PARAM_BREAK_NUM));
            }
            // lύXy[WL
            boolean changeBreak = false;
            if ( paramDef.containsKey( PARAM_CHANGE_BREAK)) {
                changeBreak = Boolean.valueOf( paramDef.get( PARAM_CHANGE_BREAK));
            }
            // JԂő
            Integer repeatNum = null;
            if ( paramDef.containsKey( PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf( paramDef.get( PARAM_REPEAT_NUM));
            }
            // V[gnCp[NݒL
            boolean sheetLink = false;
            if ( paramDef.containsKey( PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf( paramDef.get( PARAM_SHEET_LINK));
            }
            // V[gϐ
            String propertyName = null;
            if ( paramDef.containsKey( PARAM_PROPERTY)) {
                propertyName = paramDef.get( PARAM_PROPERTY);
            }
            // uϐ̎擾
            String replaceParam = paramDef.get( PARAM_VALUE);
            // VXeϐ
            if ( ReportsUtil.VALUE_SHEET_NAMES.equals( replaceParam)) {
                // V[g
                paramValues = ReportsUtil.getSheetNames( reportsParserInfo.getReportBook()).toArray();
            } else if ( ReportsUtil.VALUE_SHEET_VALUES.equals( replaceParam)) {
                // V[gl
                paramValues = ReportsUtil.getSheetValues( reportsParserInfo.getReportBook(), propertyName, reportsParserInfo.getReportParsers()).toArray();
            } else {
                // ul擾
                ParamInfo paramInfo = reportsParserInfo.getParamInfo();
                if ( paramInfo != null) {
                    paramValues = getParamData( paramInfo, replaceParam);
                }
            }

            if ( paramValues == null || paramValues.length == 0) {
                // 󕶎u
                paramValues = new Object[] {null};
            }

            // VtgZ擾
            int shiftNum = paramValues.length;
            // p[^擾
            int paramLength = paramValues.length;

            // ΏۃZ̊Jnsԍ擾
            int defaultFromCellRowIndex = tagCell.getRowIndex();
            // ΏۃZ̊Jnԍ擾
            int defaultFromCellColIndex = tagCell.getColumnIndex();

            // PʃZsTCYilFPZj
            int unitRowSize = 1;

            // ΏۃV[g茋Z擾
            List<CellRangeAddress> maegedAddresses = new ArrayList<CellRangeAddress>();
            for ( int i = 0; i < sheet.getNumMergedRegions(); i++) {
                CellRangeAddress targetAddress = sheet.getMergedRegion( i);
                maegedAddresses.add( targetAddress);
            }

            // PʃZsTCY̐ݒ
            if ( maegedAddresses.size() > 0) {
                // ΏۃV[gɌZ݂ꍇɂ͌ZJԂ
                for ( CellRangeAddress curMergedAdress : maegedAddresses) {
                    if ( defaultFromCellColIndex == curMergedAdress.getFirstColumn() && defaultFromCellRowIndex == curMergedAdress.getFirstRow()) {
                        // ΏۃZZJnԍJnsԍłꍇɂ
                        // PʃZsTCYɌZsݒ肷
                        unitRowSize = curMergedAdress.getLastRow() - curMergedAdress.getFirstRow() + 1;

                        // VtgZPʃZsTCYiZsj
                        shiftNum = shiftNum * unitRowSize;
                    }
                }
            }
            
            // VtgÕV[gitH[}bgjۑ
            // ŏIsW܂ł̃Zۑ
            List<Cell> cellList = new ArrayList<Cell>();
            int defaultToOverCellRowIndex = tagCell.getRowIndex() + unitRowSize;
            for ( int i = defaultFromCellRowIndex; i < defaultToOverCellRowIndex; i++) {
                Row targetCellRow = sheet.getRow(i);
                cellList.add( targetCellRow.getCell(tagCell.getColumnIndex()));
            }

            // VtgZ̐ݒ
            if ( repeatNum != null && repeatNum < shiftNum) {
                // JԂő񐔂w肳ĂA
                // AVtgZJԂő񐔂zĂ܂Ăꍇɂ
                // JԂő񐔁~PʃZsTCYVtgZƂ
                shiftNum = repeatNum * unitRowSize;

                // p^JԂő񐔂ɒu
                paramLength = repeatNum;
            }

            // Vtg
            if ( shiftNum > 1) {
                // l̐Vtg(Pł΁AVtgȂ)
                int shiftRowSize = tagCell.getRowIndex() + shiftNum - unitRowSize - 1;
                if ( !rowShift) {
                    // ZPʂŃVtgꍇ
                    CellRangeAddress rangeAddress = new CellRangeAddress( tagCell.getRowIndex(), shiftRowSize, tagCell.getColumnIndex(), tagCell.getColumnIndex());
                    PoiUtil.insertRangeDown( sheet, rangeAddress);
                } else {
                    // sPʂŃVtgꍇ
                    int shiftStartRow = tagCell.getRowIndex() + 1;
                    int shiftEndRow = sheet.getLastRowNum();
                    if ( shiftEndRow < shiftStartRow) {
                        // ^OIsɑ݂Ăꍇɂ́uŏIsJns{Pvɒu
                        // JnsIs{PƂȂĂ܂Ƃh
                        shiftEndRow = shiftStartRow + 1;
                    }
                    sheet.shiftRows( shiftStartRow, shiftEndRow, shiftNum - unitRowSize);
                }
            }

            // ubNAV[g̎擾
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName( workbook.getSheetIndex( sheet));
            // V[g
            List<String> sheetNames = ReportsUtil.getSheetNames( reportsParserInfo.getReportBook());
            // ϊl
            List<Object> resultValues = new ArrayList<Object>();
            // Ozl(beforeValue)
            Object beforeValue = null;

            // ݒlzCfbNX
            int valueIndex = -1;
            // VtgZ܂ōs̐ݒ菈s
            for ( int rowIndex = 0; rowIndex < shiftNum; rowIndex++) {
                // s̎擾
                Row row = sheet.getRow( tagCell.getRowIndex() + rowIndex);
                if ( row == null) {
                    row = sheet.createRow( tagCell.getRowIndex() + rowIndex);
                }
                // Z̎擾
                Cell cell = row.getCell( tagCell.getColumnIndex());
                if ( cell == null) {
                    cell = row.createCell( tagCell.getColumnIndex());
                }
                // Zɐݒ肷l̏(null)
                Object value = null;

                // Z̉ԖڂɊY邩ZɂĎZo
                // ʒl0̏ꍇA(A񌋍킸)ŏ̃Zł邱Ƃ
                int cellIndex = rowIndex % unitRowSize;
                
                // s̒lݒsZȊO͒l
                boolean skipRow = false;
                if ( cellIndex != 0) {
                    skipRow = true;
                } else {
                    valueIndex++;
                }

                // Rs[(Z̐ݒ)
                PoiUtil.copyCell( cellList.get(cellIndex), cell);

                // l̐ݒ
                Object currentValue = paramValues[valueIndex];
                // d\IvV=trueAlvꍇ̓tO
                boolean duplicateValue = false;
                if ( beforeValue != null && currentValue != null && beforeValue.equals( currentValue)) {
                    // lvꍇ
                    duplicateValue = true;
                }
                if ( !skipRow && !(hideDuplicate && duplicateValue)) {
                    // d\IvV=true
                    // Alvꍇɂ̓Zɐݒ肷lB
                    value = currentValue;
                }
                if ( log.isDebugEnabled()) {
                    log.debug( "[V[g=" + sheetName + ",Z=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + "  " + value);
                }
                PoiUtil.setCellValue( cell, value);
                resultValues.add( value);

                // nCp[Nݒ
                if ( sheetLink) {
                    if ( !skipRow && valueIndex < sheetNames.size()) {
                        PoiUtil.setHyperlink( cell, Hyperlink.LINK_DOCUMENT, "'" + sheetNames.get( valueIndex) + "'!A1");
                        if ( log.isDebugEnabled()) {
                            log.debug( "[V[g=" + sheetName + ",Z=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink  " + "'" + sheetNames.get( valueIndex) + "'!A1");
                        }
                    }
                }

                // y[WIvVw
                if ( cell instanceof HSSFCell) {
                    // TODO XSSFRowBreak͐ɓ삵Ȃ߁AHSSF̂
                    if ( !skipRow) {
                        if ( breakNum != null && valueIndex != 0 && valueIndex % breakNum == 0) {
                            // f[^ɂy[Wꍇ
                            sheet.setRowBreak( row.getRowNum() - 1);
                        }
                        if ( changeBreak && valueIndex != 0 && !duplicateValue) {
                            // lύXɂy[Wꍇ
                            sheet.setRowBreak( row.getRowNum() - 1);
                        }
                    }
                }

                // Zw
                // Xev[gŌς݂̃Z݂邽߁A
                // Z͂Qdo^Ȃ悤ɂB
                if ( !skipRow && unitRowSize > 1) {
                    // tO̐ݒ
                    boolean mergedRegionFlag = false;
                    if ( rowShift && valueIndex != 0) {
                        // sPʂŃVtgꍇAŏl͌Ȃ
                        mergedRegionFlag = true;
                    } else if ( !rowShift && paramLength > valueIndex + 1) {
                        // ZPʂŃVtgꍇAŏIl͌Ȃ
                        mergedRegionFlag = true;
                    }

                    // Zo^
                    if ( mergedRegionFlag) {
                        CellRangeAddress rangeAddress = new CellRangeAddress( cell.getRowIndex(), cell.getRowIndex() + unitRowSize - 1, cell.getColumnIndex(), cell.getColumnIndex());
                        sheet.addMergedRegion( rangeAddress);

                        // ̏ꍇ͌^C~OőO̒lXV
                        beforeValue = currentValue;
                    }
                }

                // ł͖ꍇ͖lXV
                if ( unitRowSize == 1) {
                    beforeValue = currentValue;
                }

            }

            // ͌ʂ̐
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            parsedReportInfo.setParsedObject( resultValues);
            // ŏIsݒisZԂlj
            parsedReportInfo.setDefaultRowIndex( tagCell.getRowIndex() + unitRowSize - 1);
            parsedReportInfo.setDefaultColumnIndex( tagCell.getColumnIndex());
            parsedReportInfo.setRowIndex( tagCell.getRowIndex() + shiftNum - 1);
            parsedReportInfo.setColumnIndex( tagCell.getColumnIndex());
            if ( log.isDebugEnabled()) {
                log.debug( parsedReportInfo);
            }

            return parsedReportInfo;

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef p[^`
     * @param tagCell ^OZ
     * @throws ParseException sȃp[^ꍇ
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
        // V[gnCp[NݒLƏd\͏ds
        if ( paramDef.containsKey( PARAM_DUPLICATE) && paramDef.containsKey( PARAM_SHEET_LINK)) {
            throw new ParseException( tagCell, "d`F" + PARAM_DUPLICATE + "," + PARAM_SHEET_LINK);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.bbreak.excella.reports.tag.ReportsTagParser#useControlRow()
     */
    @Override
    public boolean useControlRow() {
        return false;
    }

}
