/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.dom;

import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.attributes.AttributeFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.exceptions.EXIException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMWriter {
    protected EXIFactory factory;
    protected EXIEncoder encoder;
    private AttributeList exiAttributes;
    protected boolean preserveWhitespaces;
    protected boolean preserveComments;
    protected boolean preservePIs;

    public DOMWriter(EXIFactory factory) {
        this.factory = factory;
        this.encoder = factory.createEXIEncoder();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.preserveWhitespaces = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_WHITESPACES");
        this.preserveComments = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePIs = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutput(OutputStream os) throws EXIException {
        this.encoder.setOutput(os, this.factory.isEXIBodyOnly());
    }

    public void encode(Document doc) throws EXIException {
        this.encoder.encodeStartDocument();
        this.encodeChildNodes(doc.getChildNodes());
        this.encoder.encodeEndDocument();
    }

    public void encodeFragment(DocumentFragment docFragment) throws EXIException {
        this.encoder.encodeStartDocument();
        NodeList nl = docFragment.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            this.encodeNode(nl.item(i));
            ++i;
        }
        this.encoder.encodeEndDocument();
    }

    public void encode(Node n) throws EXIException {
        if (n.getNodeType() == 9) {
            this.encode((Document)n);
        } else if (n.getNodeType() == 11) {
            this.encodeFragment((DocumentFragment)n);
        } else {
            this.encoder.encodeStartDocument();
            this.encodeNode(n);
            this.encoder.encodeEndDocument();
        }
    }

    protected void encodeNode(Node root) throws EXIException {
        assert (root.getNodeType() == 1);
        String namespaceURI = root.getNamespaceURI() == null ? "" : root.getNamespaceURI();
        String localName = root.getLocalName();
        this.encoder.encodeStartElement(namespaceURI, localName, root.getPrefix());
        NamedNodeMap attributes = root.getAttributes();
        this.exiAttributes.parse(root.getAttributes());
        int i = 0;
        while (i < attributes.getLength()) {
            Node at = attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(at.getNamespaceURI())) {
                String pfx = at.getPrefix() == null ? "" : at.getLocalName();
                this.encoder.encodeNamespaceDeclaration(at.getNodeValue(), pfx);
            }
            ++i;
        }
        if (this.exiAttributes.hasXsiType()) {
            this.encoder.encodeXsiType(this.exiAttributes.getXsiTypeRaw());
        }
        if (this.exiAttributes.hasXsiNil()) {
            this.encoder.encodeXsiNil(this.exiAttributes.getXsiNil());
        }
        i = 0;
        while (i < this.exiAttributes.getNumberOfAttributes()) {
            this.encoder.encodeAttribute(this.exiAttributes.getAttributeURI(i), this.exiAttributes.getAttributeLocalName(i), this.exiAttributes.getAttributePrefix(i), this.exiAttributes.getAttributeValue(i));
            ++i;
        }
        NodeList children = root.getChildNodes();
        this.encodeChildNodes(children);
        this.encoder.encodeEndElement();
    }

    protected void encodeChildNodes(NodeList children) throws EXIException {
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    this.encodeNode(n);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    String value = n.getNodeValue();
                    if (!this.preserveWhitespaces && (value = value.trim()).length() <= 0) break;
                    this.encoder.encodeCharacters(value);
                    break;
                }
                case 8: {
                    if (!this.preserveComments) break;
                    String c = n.getNodeValue();
                    this.encoder.encodeComment(c.toCharArray(), 0, c.length());
                    break;
                }
                case 10: {
                    DocumentType dt = (DocumentType)n;
                    String publicID = dt.getPublicId() == null ? "" : dt.getPublicId();
                    String systemID = dt.getSystemId() == null ? "" : dt.getSystemId();
                    String text = dt.getInternalSubset() == null ? "" : dt.getInternalSubset();
                    this.encoder.encodeDocType(dt.getName(), publicID, systemID, text);
                    break;
                }
                case 5: {
                    break;
                }
                case 7: {
                    if (!this.preservePIs) break;
                    ProcessingInstruction pi = (ProcessingInstruction)n;
                    this.encoder.encodeProcessingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                default: {
                    System.err.println("[WARNING] Unhandled DOM NodeType: " + n.getNodeType());
                }
            }
            ++i;
        }
    }
}

