/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIEncoderPrefixLess;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;
import java.util.Enumeration;

public class EXIEncoderPrefixAware
extends EXIEncoderPrefixLess
implements EXIEncoder {
    protected String lastSEprefix = null;

    public EXIEncoderPrefixAware(EXIFactory exiFactory) {
        super(exiFactory);
    }

    protected void encodeQNamePrefix(String uri, String prefix) throws IOException {
        Enumeration<String> prefixes4GivenURI = this.namespaces.getPrefixes(uri);
        if (!uri.equals("") && prefixes4GivenURI.hasMoreElements()) {
            int numberOfPrefixes = 0;
            int id = -1;
            do {
                if (prefixes4GivenURI.nextElement().equals(prefix)) {
                    id = numberOfPrefixes;
                }
                ++numberOfPrefixes;
            } while (prefixes4GivenURI.hasMoreElements());
            if (numberOfPrefixes > 1) {
                this.block.writeEventCode(id, MethodsBag.getCodingLength(numberOfPrefixes));
            }
        }
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException {
        super.encodeStartElement(uri, localName, prefix);
        this.lastSEprefix = prefix;
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException {
        super.encodeNamespaceDeclaration(uri, prefix);
        assert (this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES"));
        try {
            int ec2 = this.currentRule.get2ndLevelEventCode(EventType.NAMESPACE_DECLARATION, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2);
            this.block.writeUri(uri);
            this.block.writePrefix(prefix, uri);
            if (prefix.equals(this.lastSEprefix)) {
                this.block.writeBoolean(true);
            } else {
                this.block.writeBoolean(false);
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }
}

