/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import java.io.IOException;
import java.io.OutputStream;

public class EXIHeader {
    public static final int NUMBER_OF_DISTINGUISHING_BITS = 2;
    public static final int DISTINGUISHING_BITS_VALUE = 2;
    public static final int NUMBER_OF_FORMAT_VERSION_BITS = 4;
    public static final int FORMAT_VERSION_CONTINUE_VALUE = 15;

    public static void write(OutputStream os) throws EXIException {
        try {
            int b = 144;
            os.write(b);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public static void parse(BitDecoderChannel headerChannel) throws EXIException {
        try {
            int value;
            if (headerChannel.decodeNBitUnsignedInteger(2) != 2) {
                throw new IOException("No valid EXI document according distinguishing bits");
            }
            boolean presenceOptions = headerChannel.decodeBoolean();
            boolean previewVersion = headerChannel.decodeBoolean();
            int version = 0;
            do {
                value = headerChannel.decodeNBitUnsignedInteger(4);
                version += value;
            } while (value == 15);
            if (presenceOptions) {
                throw new RuntimeException("[EXI Header] Options section not implemented yet");
            }
            headerChannel.align();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }
}

