/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.sax;

import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.EventType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXDecoder
implements XMLReader {
    protected EXIFactory exiFactory;
    protected EXIDecoder decoder;
    protected ContentHandler contentHandler;
    protected DTDHandler dtdHandler;
    protected ErrorHandler errorHandler;
    protected static final String ATTRIBUTE_TYPE = "CDATA";
    protected AttributesImpl attributes = new AttributesImpl();
    protected NamespaceSupport namespaces;
    protected Map<String, String> createdPrefixes;
    protected int createdPfxCnt = 1;
    protected String deferredStartElementUri;
    protected String deferredStartElementLocalName;
    protected List<String> eeQualifiedNames;

    public SAXDecoder(EXIFactory exiFactory) {
        this.exiFactory = exiFactory;
        this.decoder = exiFactory.createEXIDecoder();
    }

    protected void init() {
        this.deferredStartElementUri = null;
        this.deferredStartElementLocalName = null;
        this.eeQualifiedNames = new ArrayList<String>();
        this.namespaces = this.decoder.getNamespaces();
        this.createdPrefixes = new HashMap<String, String>();
        this.createdPfxCnt = 1;
    }

    protected void checkDeferredStartElement() throws SAXException {
        if (this.deferredStartElementUri != null) {
            Enumeration<String> declaredPrefixes = this.namespaces.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String pfx = declaredPrefixes.nextElement();
                String uri = this.namespaces.getURI(pfx) == null ? "" : this.namespaces.getURI(pfx);
                this.contentHandler.startPrefixMapping(pfx, uri);
            }
            String qname = this.getElementQualifiedName(this.deferredStartElementUri, this.deferredStartElementLocalName);
            this.eeQualifiedNames.add(qname);
            this.contentHandler.startElement(this.deferredStartElementUri, this.deferredStartElementLocalName, qname, this.attributes);
            this.deferredStartElementUri = null;
            this.deferredStartElementLocalName = null;
            this.attributes.clear();
        }
    }

    protected String getAttributeQualifiedName(String attributeURI, String attributeLocalName) throws SAXException {
        String pfx = this.decoder.getAttributePrefix();
        if (pfx == null) {
            if (attributeURI.equals(this.namespaces.getURI("")) || attributeURI.equals("")) {
                pfx = "";
            } else {
                pfx = this.namespaces.getPrefix(attributeURI);
                if (pfx == null) {
                    pfx = this.getUniquePrefix(attributeURI);
                }
            }
        }
        return pfx.length() == 0 ? attributeLocalName : String.valueOf(pfx) + ":" + attributeLocalName;
    }

    protected String getElementQualifiedName(String elementURI, String elementLocalName) throws SAXException {
        String pfx = this.decoder.getElementPrefix();
        if (pfx == null) {
            if (elementURI.equals("") || elementURI.equals(this.namespaces.getURI(""))) {
                pfx = "";
            } else {
                pfx = this.namespaces.getPrefix(elementURI);
                if (pfx == null) {
                    pfx = this.getUniquePrefix(elementURI);
                }
            }
        }
        return pfx.length() == 0 ? elementLocalName : String.valueOf(pfx) + ":" + elementLocalName;
    }

    protected String getUniquePrefix(String uri) throws SAXException {
        String pfx;
        if (this.createdPrefixes.containsKey(uri)) {
            pfx = this.createdPrefixes.get(uri);
            if (this.namespaces.getPrefix(uri) == null) {
                this.declarePrefix(pfx, uri);
            }
        } else {
            while (this.namespaces.getURI(pfx = "ns" + this.createdPfxCnt++) != null) {
            }
            this.declarePrefix(pfx, uri);
            this.createdPrefixes.put(uri, pfx);
        }
        return pfx;
    }

    protected void declarePrefix(String prefix, String uri) throws SAXException {
        this.namespaces.declarePrefix(prefix, uri);
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void parse(String systemId) throws IOException, SAXException {
        FileInputStream fis = new FileInputStream(systemId);
        InputSource is = new InputSource(fis);
        this.parse(is);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        assert (inputSource != null);
        assert (this.decoder != null);
        try {
            InputStream inputStream = inputSource.getByteStream();
            this.decoder.setInputStream(inputStream, this.exiFactory.isEXIBodyOnly());
            if (this.contentHandler == null) {
                throw new SAXException("No content handler set!");
            }
            this.init();
            this.decoder.inspectEvent();
            while (this.decoder.hasNextEvent()) {
                EventType eventType = this.decoder.getNextEventType();
                switch (eventType) {
                    case START_DOCUMENT: {
                        this.decoder.decodeStartDocument();
                        this.contentHandler.startDocument();
                        break;
                    }
                    case START_ELEMENT: 
                    case START_ELEMENT_GENERIC: 
                    case START_ELEMENT_GENERIC_UNDECLARED: {
                        this.checkDeferredStartElement();
                        if (eventType == EventType.START_ELEMENT) {
                            this.decoder.decodeStartElement();
                        } else if (eventType == EventType.START_ELEMENT_GENERIC) {
                            this.decoder.decodeStartElementGeneric();
                        } else {
                            this.decoder.decodeStartElementGenericUndeclared();
                        }
                        this.deferredStartElementUri = this.decoder.getElementURI();
                        this.deferredStartElementLocalName = this.decoder.getElementLocalName();
                        break;
                    }
                    case NAMESPACE_DECLARATION: {
                        this.decoder.decodeNamespaceDeclaration();
                        this.declarePrefix(this.decoder.getNSPrefix(), this.decoder.getNSUri());
                        break;
                    }
                    case ATTRIBUTE: 
                    case ATTRIBUTE_GENERIC: 
                    case ATTRIBUTE_GENERIC_UNDECLARED: 
                    case ATTRIBUTE_INVALID_VALUE: {
                        if (eventType == EventType.ATTRIBUTE) {
                            this.decoder.decodeAttribute();
                        } else if (eventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                            this.decoder.decodeAttributeInvalidValue();
                        } else if (eventType == EventType.ATTRIBUTE_GENERIC) {
                            this.decoder.decodeAttributeGeneric();
                        } else {
                            this.decoder.decodeAttributeGenericUndeclared();
                        }
                        String attributeURI = this.decoder.getAttributeURI();
                        String attributeLocalName = this.decoder.getAttributeLocalName();
                        String attributeValue = this.decoder.getAttributeValue();
                        this.attributes.addAttribute(attributeURI, attributeLocalName, this.getAttributeQualifiedName(attributeURI, attributeLocalName), ATTRIBUTE_TYPE, attributeValue);
                        break;
                    }
                    case ATTRIBUTE_XSI_TYPE: {
                        this.decoder.decodeXsiType();
                        this.attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.getAttributeQualifiedName("http://www.w3.org/2001/XMLSchema-instance", "type"), ATTRIBUTE_TYPE, this.getAttributeQualifiedName(this.decoder.getXsiTypeUri(), this.decoder.getXsiTypeName()));
                        break;
                    }
                    case ATTRIBUTE_XSI_NIL: 
                    case ATTRIBUTE_XSI_NIL_DEVIATION: {
                        String attributeXsiValue;
                        if (eventType == EventType.ATTRIBUTE_XSI_NIL) {
                            this.decoder.decodeXsiNil();
                            attributeXsiValue = this.decoder.getXsiNil() ? "true" : "false";
                        } else {
                            this.decoder.decodeXsiNilDeviation();
                            attributeXsiValue = this.decoder.getXsiNilDeviation();
                        }
                        this.attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", this.getAttributeQualifiedName("http://www.w3.org/2001/XMLSchema-instance", "nil"), ATTRIBUTE_TYPE, attributeXsiValue);
                        break;
                    }
                    case CHARACTERS_GENERIC: 
                    case CHARACTERS: 
                    case CHARACTERS_GENERIC_UNDECLARED: {
                        this.checkDeferredStartElement();
                        if (eventType == EventType.CHARACTERS) {
                            this.decoder.decodeCharacters();
                        } else if (eventType == EventType.CHARACTERS_GENERIC) {
                            this.decoder.decodeCharactersGeneric();
                        } else {
                            this.decoder.decodeCharactersGenericUndeclared();
                        }
                        this.contentHandler.characters(this.decoder.getCharacters().toCharArray(), 0, this.decoder.getCharacters().length());
                        break;
                    }
                    case END_ELEMENT: 
                    case END_ELEMENT_UNDECLARED: {
                        this.checkDeferredStartElement();
                        String eeUri = this.decoder.getScopeURI();
                        String eeLocalName = this.decoder.getScopeLocalName();
                        if (eventType == EventType.END_ELEMENT) {
                            this.decoder.decodeEndElement();
                        } else {
                            this.decoder.decodeEndElementUndeclared();
                        }
                        this.contentHandler.endElement(eeUri, eeLocalName, this.eeQualifiedNames.remove(this.eeQualifiedNames.size() - 1));
                        break;
                    }
                    case DOC_TYPE: {
                        this.decoder.decodeDocType();
                        this.handleDocType();
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        this.checkDeferredStartElement();
                        this.decoder.decodeEntityReference();
                        this.handleEntityReference();
                        break;
                    }
                    case COMMENT: {
                        this.checkDeferredStartElement();
                        this.decoder.decodeComment();
                        this.handleComment();
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.checkDeferredStartElement();
                        this.decoder.decodeProcessingInstruction();
                        this.contentHandler.processingInstruction(this.decoder.getPITarget(), this.decoder.getPIData());
                        break;
                    }
                    case SELF_CONTAINED: {
                        this.decoder.decodeStartFragmentSelfContained();
                        break;
                    }
                    case END_DOCUMENT: {
                        this.decoder.decodeEndFragmentSelfContained();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown event while decoding! " + (Object)((Object)this.decoder.getNextEventType()));
                    }
                }
                this.decoder.inspectEvent();
            }
            this.decoder.decodeEndDocument();
            this.contentHandler.endDocument();
        }
        catch (EXIException e) {
            throw new SAXException("EXI", e);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    protected void handleDocType() throws SAXException, IOException {
    }

    protected void handleEntityReference() throws SAXException {
    }

    protected void handleComment() throws SAXException {
    }
}

