/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.decoder;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.decoder.AbstractDatatypeDecoder;
import com.siemens.ct.exi.datatype.decoder.TypeDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoder;
import com.siemens.ct.exi.exceptions.UnknownElementException;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import java.io.IOException;

public class RestrictedCharacterSetDatatypeDecoder
extends AbstractDatatypeDecoder {
    protected RestrictedCharacterSet rcs;

    public RestrictedCharacterSetDatatypeDecoder(RestrictedCharacterSet rcs) {
        this.rcs = rcs;
    }

    public String decodeValue(TypeDecoder decoder, Datatype datatype, DecoderChannel dc, String namespaceURI, String localName) throws IOException {
        String value;
        int i = dc.decodeUnsignedInteger();
        if (i == 0) {
            value = decoder.readStringAsLocalHit(dc, namespaceURI, localName);
        } else if (i == 1) {
            value = decoder.readStringAsGlobalHit(dc);
        } else {
            int slen = i - 2;
            int numberOfBits = this.rcs.getCodingLength();
            int size = this.rcs.size();
            StringBuilder sb = new StringBuilder();
            try {
                int k = 0;
                while (k < slen) {
                    int code = dc.decodeNBitUnsignedInteger(numberOfBits);
                    if (code == size) {
                        sb.append((char)dc.decodeUnsignedInteger());
                    } else {
                        sb.append(this.rcs.getCharacter(code));
                    }
                    ++k;
                }
            }
            catch (UnknownElementException e) {
                throw new IOException(e.getMessage());
            }
            value = sb.toString();
            StringTableDecoder stringTable = decoder.getStringTable();
            stringTable.addLocalValue(namespaceURI, localName, value);
            stringTable.addGlobalValue(value);
        }
        return value;
    }
}

