/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.encoder.AbstractTypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import java.io.IOException;

public abstract class AbstractTypeEncoderSchemaInformed
extends AbstractTypeEncoder {
    protected DatatypeEncoder lastDatatypeEncoder;
    protected DatatypeEncoder binaryBase64DTE;
    protected DatatypeEncoder binaryHexDTE;
    protected DatatypeEncoder booleanDTE;
    protected DatatypeEncoder booleanPatternDTE;
    protected DatatypeEncoder decimalDTE;
    protected DatatypeEncoder floatDTE;
    protected DatatypeEncoder integerDTE;
    protected DatatypeEncoder unsignedIntegerDTE;
    protected DatatypeEncoder nBitIntegerDTE;
    protected DatatypeEncoder datetimeDTE;
    protected DatatypeEncoder enumerationDTE;
    protected DatatypeEncoder listDTE;
    protected DatatypeEncoder stringDTE;

    public AbstractTypeEncoderSchemaInformed(EXIFactory exiFactory) {
        super(exiFactory);
    }

    public boolean isTypeValid(Datatype datatype, String value) {
        switch (datatype.getDefaultBuiltInType()) {
            case BUILTIN_BINARY_BASE64: {
                this.lastDatatypeEncoder = this.binaryBase64DTE;
                break;
            }
            case BUILTIN_BINARY_HEX: {
                this.lastDatatypeEncoder = this.binaryHexDTE;
                break;
            }
            case BUILTIN_BOOLEAN: {
                this.lastDatatypeEncoder = this.booleanDTE;
                break;
            }
            case BUILTIN_BOOLEAN_PATTERN: {
                this.lastDatatypeEncoder = this.booleanPatternDTE;
                break;
            }
            case BUILTIN_DECIMAL: {
                this.lastDatatypeEncoder = this.decimalDTE;
                break;
            }
            case BUILTIN_FLOAT: {
                this.lastDatatypeEncoder = this.floatDTE;
                break;
            }
            case BUILTIN_INTEGER: {
                this.lastDatatypeEncoder = this.integerDTE;
                break;
            }
            case BUILTIN_UNSIGNED_INTEGER: {
                this.lastDatatypeEncoder = this.unsignedIntegerDTE;
                break;
            }
            case BUILTIN_NBIT_INTEGER: {
                this.lastDatatypeEncoder = this.nBitIntegerDTE;
                break;
            }
            case BUILTIN_DATETIME: {
                this.lastDatatypeEncoder = this.datetimeDTE;
                break;
            }
            case BUILTIN_ENUMERATION: {
                this.lastDatatypeEncoder = this.enumerationDTE;
                break;
            }
            case BUILTIN_LIST: {
                this.lastDatatypeEncoder = this.listDTE;
                break;
            }
            case BUILTIN_STRING: {
                this.lastDatatypeEncoder = this.stringDTE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown BuiltIn Type");
            }
        }
        return this.lastDatatypeEncoder.isValid(datatype, value);
    }

    public void writeTypeValidValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        this.lastDatatypeEncoder.writeValue(valueChannel, uri, localName);
    }
}

