/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeEnumeration;
import com.siemens.ct.exi.datatype.encoder.AbstractDatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import java.io.IOException;
import org.apache.xerces.xs.StringList;

public class EnumerationDatatypeEncoder
extends AbstractDatatypeEncoder
implements DatatypeEncoder {
    private DatatypeEnumeration lastDatatypeEnumeration;
    private StringList lastEnumValues;
    private int lastOrdinalPosition;

    public EnumerationDatatypeEncoder(TypeEncoder typeEncoder) {
        super(typeEncoder);
    }

    public boolean isValid(Datatype datatype, String value) {
        this.lastDatatypeEnumeration = (DatatypeEnumeration)datatype;
        this.lastEnumValues = this.lastDatatypeEnumeration.getEnumerationValues();
        this.lastOrdinalPosition = -1;
        int index = 0;
        while (index < this.lastEnumValues.getLength()) {
            if (this.lastEnumValues.item(index).equals(value)) {
                this.lastOrdinalPosition = index;
                return true;
            }
            ++index;
        }
        return false;
    }

    public void writeValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastOrdinalPosition, this.lastDatatypeEnumeration.getCodingLength());
    }
}

