/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeList;
import com.siemens.ct.exi.datatype.encoder.AbstractDatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import java.io.IOException;
import java.util.StringTokenizer;

public class ListDatatypeEncoder
extends AbstractDatatypeEncoder
implements DatatypeEncoder {
    protected Datatype listDatatype;
    protected TypeEncoder listTypeEncoder = null;
    protected EXIFactory exiFactory;
    protected int numberOfEnumeratedTypes;
    protected String lastValidValue;

    public ListDatatypeEncoder(TypeEncoder typeEncoder, EXIFactory exiFactory) {
        super(typeEncoder);
        this.exiFactory = exiFactory;
    }

    public boolean isValid(Datatype datatype, String value) {
        if (this.listTypeEncoder == null) {
            this.listTypeEncoder = this.exiFactory.createTypeEncoder();
        }
        this.listDatatype = ((DatatypeList)datatype).getListDatatype();
        StringTokenizer st = new StringTokenizer(value, " ");
        this.numberOfEnumeratedTypes = 0;
        while (st.hasMoreTokens()) {
            if (!this.listTypeEncoder.isTypeValid(this.listDatatype, st.nextToken())) {
                return false;
            }
            ++this.numberOfEnumeratedTypes;
        }
        this.lastValidValue = value;
        return true;
    }

    public void writeValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        valueChannel.encodeUnsignedInteger(this.numberOfEnumeratedTypes);
        StringTokenizer st = new StringTokenizer(this.lastValidValue, " ");
        while (st.hasMoreTokens()) {
            this.listTypeEncoder.isTypeValid(this.listDatatype, st.nextToken());
            this.listTypeEncoder.writeTypeValidValue(valueChannel, uri, localName);
        }
    }
}

