/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeNBitInteger;
import com.siemens.ct.exi.datatype.encoder.AbstractDatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.datatype.XSDInteger;
import java.io.IOException;

public class NBitIntegerDatatypeEncoder
extends AbstractDatatypeEncoder
implements DatatypeEncoder {
    private XSDInteger lastNBitInteger = XSDInteger.newInstance();
    private int valueToEncode;
    private int numberOfBits;

    public NBitIntegerDatatypeEncoder(TypeEncoder typeEncoder) {
        super(typeEncoder);
    }

    public boolean isValid(Datatype datatype, String value) {
        try {
            this.lastNBitInteger.parse(value);
            assert (datatype instanceof DatatypeNBitInteger);
            DatatypeNBitInteger nBitDT = (DatatypeNBitInteger)datatype;
            if (this.lastNBitInteger.compareTo(nBitDT.getLowerBound()) >= 0 && this.lastNBitInteger.compareTo(nBitDT.getUpperBound()) <= 0) {
                this.valueToEncode = this.lastNBitInteger.subtract(nBitDT.getLowerBound()).getIntInteger();
                this.numberOfBits = nBitDT.getNumberOfBits();
                return true;
            }
            return false;
        }
        catch (XMLParsingException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.valueToEncode, this.numberOfBits);
    }
}

