/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.encoder.AbstractDatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import java.io.IOException;

public class RestrictedCharacterSetDatatypeEncoder
extends AbstractDatatypeEncoder
implements DatatypeEncoder {
    protected RestrictedCharacterSet rcs;
    protected String lastValidValue;

    public RestrictedCharacterSetDatatypeEncoder(TypeEncoder typeEncoder, RestrictedCharacterSet rcs) {
        super(typeEncoder);
        this.rcs = rcs;
    }

    public boolean isValid(Datatype datatype, String value) {
        this.lastValidValue = value;
        return true;
    }

    public void writeValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        if (!this.typeEncoder.writeStringAsLocalHit(valueChannel, uri, localName, this.lastValidValue) && !this.typeEncoder.writeStringAsGlobalHit(valueChannel, this.lastValidValue)) {
            int numberOfTuples = this.lastValidValue.length();
            valueChannel.encodeUnsignedInteger(numberOfTuples + 2);
            int numberOfBits = this.rcs.getCodingLength();
            int i = 0;
            while (i < numberOfTuples) {
                char ch = this.lastValidValue.charAt(i);
                int code = this.rcs.getCode(ch);
                if (code == -1) {
                    valueChannel.encodeNBitUnsignedInteger(this.rcs.size(), numberOfBits);
                    valueChannel.encodeUnsignedInteger(ch);
                } else {
                    valueChannel.encodeNBitUnsignedInteger(code, numberOfBits);
                }
                ++i;
            }
            StringTableEncoder stringTable = this.typeEncoder.getStringTable();
            stringTable.addLocalValue(uri, localName, this.lastValidValue);
            stringTable.addGlobalValue(this.lastValidValue);
        }
    }
}

