/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeRepresentation;
import com.siemens.ct.exi.datatype.encoder.AbstractTypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoderTyped;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.ExpandedName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeEncoderDatatypeRespresentationMap
extends AbstractTypeEncoder {
    private TypeEncoderTyped defaultEncoder;
    private Map<ExpandedName, DatatypeRepresentation> userDefinedDatatypeRepresentations = new HashMap<ExpandedName, DatatypeRepresentation>();
    private boolean usePluggableCodec;
    private DatatypeRepresentation lastPluggableEncoder;

    public TypeEncoderDatatypeRespresentationMap(EXIFactory exiFactory) {
        super(exiFactory);
        this.defaultEncoder = new TypeEncoderTyped(exiFactory, this.stringTable);
    }

    public void registerDatatypeRepresentation(DatatypeRepresentation datatypeRepresentation) {
        this.userDefinedDatatypeRepresentations.put(datatypeRepresentation.getSchemaDatatype(), datatypeRepresentation);
    }

    public boolean isTypeValid(Datatype datatype, String value) {
        if (this.userDefinedDatatypeRepresentations.containsKey(datatype.getDatatypeIdentifier())) {
            this.usePluggableCodec = true;
            this.lastPluggableEncoder = this.userDefinedDatatypeRepresentations.get(datatype.getDatatypeIdentifier());
            return this.lastPluggableEncoder.isValid(datatype, value);
        }
        this.usePluggableCodec = false;
        this.lastPluggableEncoder = null;
        return this.defaultEncoder.isTypeValid(datatype, value);
    }

    public void writeTypeValidValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        if (this.usePluggableCodec) {
            this.lastPluggableEncoder.writeValue(valueChannel, uri, localName);
        } else {
            this.defaultEncoder.writeTypeValidValue(valueChannel, uri, localName);
        }
    }

    public void finish() throws IOException {
        Iterator<DatatypeRepresentation> iter = this.userDefinedDatatypeRepresentations.values().iterator();
        while (iter.hasNext()) {
            iter.next().finish();
        }
    }
}

