/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar;

import com.siemens.ct.exi.datatype.BuiltIn;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.ElementKey;
import com.siemens.ct.exi.grammar.GrammarSchemaInformed;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.CharactersGeneric;
import com.siemens.ct.exi.grammar.event.EndElement;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.Lambda;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.RuleContentAllSchemaInformed;
import com.siemens.ct.exi.grammar.rule.RuleElementSchemaInformed;
import com.siemens.ct.exi.grammar.rule.RuleStartTagSchemaInformed;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.util.ExpandedName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGrammarBuilder
implements DOMErrorHandler {
    private final Event END_ELEMENT;
    private final Event LAMBDA;
    protected Map<ElementKey, Rule> elementDispatcher;
    protected Map<ExpandedName, TypeGrammar> grammarTypes;
    protected Set<ExpandedName> sortedLocalNames;
    private XSModel xsModel;
    private List<XSElementDeclaration> handledElements;
    private Stack<ExpandedName> enclosingElements;
    private Map<ExpandedName, SchemaInformedRule> ruleForType;
    private List<XSElementDeclaration> outstandingElements;
    private Map<XSElementDeclaration, XSTypeDefinition> type4Element;
    private XSLoader xsLoader;
    private List<DOMError> schemaParsingErrors;
    private ArrayList<ElementKey> unusableKeys = new ArrayList();

    protected XSDGrammarBuilder() {
        this.END_ELEMENT = new EndElement();
        this.LAMBDA = new Lambda();
        this.elementDispatcher = new HashMap<ElementKey, Rule>();
        this.handledElements = new Vector<XSElementDeclaration>();
        this.enclosingElements = new Stack();
        this.ruleForType = new HashMap<ExpandedName, SchemaInformedRule>();
        this.grammarTypes = new HashMap<ExpandedName, TypeGrammar>();
        this.sortedLocalNames = new TreeSet<ExpandedName>();
        this.outstandingElements = new ArrayList<XSElementDeclaration>();
        this.type4Element = new HashMap<XSElementDeclaration, XSTypeDefinition>();
        this.schemaParsingErrors = new ArrayList<DOMError>();
        try {
            this.xsLoader = this.getXSLoader();
        }
        catch (Exception e) {
            this.xsLoader = null;
        }
    }

    protected void init() {
        this.elementDispatcher.clear();
        this.handledElements.clear();
        this.enclosingElements.clear();
        this.enclosingElements.push(null);
        this.ruleForType.clear();
        this.grammarTypes.clear();
        this.sortedLocalNames.clear();
        this.outstandingElements.clear();
        this.type4Element.clear();
    }

    public static XSDGrammarBuilder newInstance() {
        return new XSDGrammarBuilder();
    }

    public GrammarSchemaInformed build(XSModel xsModel) throws EXIException {
        if (xsModel == null || this.schemaParsingErrors.size() > 0) {
            String exMsg = "Problem occured while building XML Schema Model (XSModel)!";
            int i = 0;
            while (i < this.schemaParsingErrors.size()) {
                exMsg = String.valueOf(exMsg) + "\n. " + this.schemaParsingErrors.get(i).getMessage();
                ++i;
            }
            throw new EXIException(exMsg);
        }
        this.xsModel = xsModel;
        this.init();
        ExpandedName[] globalElements = this.initGrammars();
        GrammarSchemaInformed sig = new GrammarSchemaInformed(globalElements);
        String[] uris = this.initURITableEntries();
        sig.setUriEntries(uris);
        ExpandedName[] localNames = new ExpandedName[this.sortedLocalNames.size()];
        this.sortedLocalNames.toArray(localNames);
        sig.setLocalNamesEntries(localNames);
        for (ElementKey elementKey : this.elementDispatcher.keySet()) {
            sig.addElementRule(elementKey, this.elementDispatcher.get(elementKey));
        }
        for (ExpandedName typeName : this.grammarTypes.keySet()) {
            sig.addTypeGrammar(typeName, this.grammarTypes.get(typeName));
        }
        return sig;
    }

    public GrammarSchemaInformed build(String xsdLocation) throws EXIException {
        return this.build(this.getXSModel(xsdLocation));
    }

    public GrammarSchemaInformed build(InputStream inputStream) throws EXIException {
        return this.build(this.getXSModel(inputStream));
    }

    private XSLoader getXSLoader() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMConfiguration config = schemaLoader.getConfig();
        config.setParameter("error-handler", this);
        config.setParameter("validate", Boolean.TRUE);
        return schemaLoader;
    }

    @Override
    public boolean handleError(DOMError error) {
        this.schemaParsingErrors.add(error);
        short severity = error.getSeverity();
        if (severity == 2) {
            String msg = "[xs-error]: " + error.getMessage();
            throw new RuntimeException(msg);
        }
        if (severity == 1) {
            String msg = "[xs-warning]: " + error.getMessage();
            throw new RuntimeException(msg);
        }
        return true;
    }

    private void checkXSLoader() throws EXIException {
        if (this.xsLoader == null) {
            throw new EXIException("Problems while creating XML Schema loader");
        }
    }

    public XSModel getXSModel(String xsd) throws EXIException {
        this.checkXSLoader();
        this.schemaParsingErrors.clear();
        return this.xsLoader.loadURI(xsd);
    }

    public XSModel getXSModel(LSInput ls) throws EXIException {
        this.checkXSLoader();
        this.schemaParsingErrors.clear();
        return this.xsLoader.load(ls);
    }

    public XSModel getXSModel(InputStream inputStream) throws EXIException {
        DOMInputImpl lsInput = new DOMInputImpl();
        lsInput.setByteStream(inputStream);
        return this.getXSModel((LSInput)lsInput);
    }

    private static boolean isNamespacesOfInterest(String namespaceURI) {
        return namespaceURI != null && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema");
    }

    private String[] initURITableEntries() {
        StringList namespaces = this.xsModel.getNamespaces();
        TreeSet<String> sortedURIs = new TreeSet<String>();
        int i = 0;
        while (i < namespaces.getLength()) {
            if (XSDGrammarBuilder.isNamespacesOfInterest(namespaces.item(i))) {
                sortedURIs.add(namespaces.item(i));
            }
            ++i;
        }
        String[] uris = new String[sortedURIs.size()];
        sortedURIs.toArray(uris);
        return uris;
    }

    private void addLocalNameStringEntry(ExpandedName expName) {
        if (XSDGrammarBuilder.isNamespacesOfInterest(expName.getNamespaceURI()) && !this.sortedLocalNames.contains(expName)) {
            this.sortedLocalNames.add(expName);
        }
    }

    private ExpandedName[] initGrammars() {
        ArrayList<ExpandedName> docElements = new ArrayList<ExpandedName>();
        XSNamedMap types = this.xsModel.getComponents((short)3);
        int i = 0;
        while (i < types.getLength()) {
            XSTypeDefinition td = (XSTypeDefinition)types.item(i);
            ExpandedName name = new ExpandedName(td.getNamespace(), td.getName());
            TypeGrammar typeGrammar = this.translateTypeDefinitionToFSA(td);
            this.grammarTypes.put(name, typeGrammar);
            ++i;
        }
        this.handledElements.clear();
        XSNamedMap globalElements = this.xsModel.getComponents((short)2);
        int i2 = 0;
        while (i2 < globalElements.getLength()) {
            XSElementDeclaration globalElement = (XSElementDeclaration)globalElements.item(i2);
            docElements.add(new ExpandedName(globalElement.getNamespace(), globalElement.getName()));
            if (!this.type4Element.containsKey(globalElement)) {
                this.type4Element.put(globalElement, globalElement.getTypeDefinition());
            }
            this.translatElementDeclarationToFSA(globalElement, null);
            ++i2;
        }
        if (this.outstandingElements.size() > 0) {
            i2 = 0;
            while (i2 < this.outstandingElements.size()) {
                XSElementDeclaration outstandingElement = this.outstandingElements.get(i2);
                XSComplexTypeDefinition enclosingType = outstandingElement.getEnclosingCTDefinition();
                ArrayList<ExpandedName> enclosingElements = null;
                if (enclosingType != null) {
                    enclosingElements = this.getPossibleEnclosingElements((XSTypeDefinition)enclosingType);
                }
                if (enclosingElements == null || enclosingElements.size() == 0) {
                    this.translatElementDeclarationToFSA(outstandingElement, null);
                } else {
                    int k = 0;
                    while (k < enclosingElements.size()) {
                        this.translatElementDeclarationToFSA(outstandingElement, enclosingElements.get(k));
                        ++k;
                    }
                }
                ++i2;
            }
        }
        ExpandedName[] xx = new ExpandedName[docElements.size()];
        return docElements.toArray(xx);
    }

    private ArrayList<ExpandedName> getPossibleEnclosingElements(XSTypeDefinition enclosingType) {
        Iterator<XSElementDeclaration> iter = this.type4Element.keySet().iterator();
        ArrayList<ExpandedName> enclosingElements = new ArrayList<ExpandedName>();
        while (iter.hasNext()) {
            XSElementDeclaration el = iter.next();
            XSTypeDefinition elementType = this.type4Element.get(el);
            if (enclosingType != elementType && !enclosingType.derivedFromType(elementType, (short)1)) continue;
            enclosingElements.add(new ExpandedName(el.getNamespace(), el.getName()));
        }
        return enclosingElements;
    }

    private void addToElementDispatcher(ElementKey key, Rule r) {
        if (!this.unusableKeys.contains(key)) {
            if (this.elementDispatcher.containsKey(key)) {
                Rule existingRule = this.elementDispatcher.get(key);
                if (existingRule != r) {
                    this.elementDispatcher.remove(key);
                    this.unusableKeys.add(key);
                }
            } else {
                this.elementDispatcher.put(key, r);
            }
        }
    }

    private void addRuleFor(ExpandedName name, ExpandedName scope, ExpandedName type, SchemaInformedRule r) {
        ElementKey keyA = new ElementKey(name);
        this.addToElementDispatcher(keyA, r);
        if (scope != null) {
            ElementKey keyB = new ElementKey(name, scope, null);
            this.addToElementDispatcher(keyB, r);
        }
        if (type != null) {
            ElementKey keyC = new ElementKey(name, null, type);
            this.addToElementDispatcher(keyC, r);
        }
        if (scope != null && type != null) {
            ElementKey keyD = new ElementKey(name, scope, type);
            this.addToElementDispatcher(keyD, r);
        }
    }

    private static Vector<XSAttributeUse> getSortedAttributes(XSObjectList attributes) {
        Vector<String> vQnames = new Vector<String>();
        Hashtable<String, XSAttributeUse> ht = new Hashtable<String, XSAttributeUse>();
        int i = 0;
        while (i < attributes.getLength()) {
            XSObject attr = attributes.item(i);
            if (attr.getType() != 4) {
                throw new IllegalArgumentException("[ERROR] Unknown Attribute type: " + attr.getType());
            }
            XSAttributeUse attrUse = (XSAttributeUse)attr;
            XSAttributeDeclaration attrDecl = attrUse.getAttrDeclaration();
            String key = String.valueOf(attrDecl.getName()) + attrDecl.getNamespace();
            vQnames.addElement(key);
            ht.put(key, attrUse);
            ++i;
        }
        Collections.sort(vQnames);
        Vector<XSAttributeUse> vSortedAttributes = new Vector<XSAttributeUse>();
        int i2 = 0;
        while (i2 < vQnames.size()) {
            XSAttributeUse xsAttr = (XSAttributeUse)ht.get(vQnames.elementAt(i2));
            vSortedAttributes.addElement(xsAttr);
            ++i2;
        }
        return vSortedAttributes;
    }

    protected Attribute getAttributeEvent(XSAttributeUse attrUse) {
        XSTypeDefinition tdBase;
        XSAttributeDeclaration attrDecl = attrUse.getAttrDeclaration();
        XSSimpleTypeDefinition attrTypeDefinition = attrDecl.getTypeDefinition();
        ExpandedName atName = new ExpandedName(attrDecl.getNamespace(), attrDecl.getName());
        this.addLocalNameStringEntry(atName);
        ExpandedName qNameType = attrTypeDefinition.getAnonymous() ? ((tdBase = attrTypeDefinition.getBaseType()).getName() == null ? BuiltIn.DEFAULT_VALUE_NAME : new ExpandedName(tdBase.getNamespace(), tdBase.getName())) : new ExpandedName(attrTypeDefinition.getNamespace(), attrTypeDefinition.getName());
        return new Attribute(atName.getNamespaceURI(), atName.getLocalName(), qNameType, BuiltIn.getDatatype(attrTypeDefinition));
    }

    private SchemaInformedRule handleAttributes(SchemaInformedRule ruleContent, SchemaInformedRule ruleContent2, XSObjectList attributes) {
        RuleStartTagSchemaInformed ruleCurrent = new RuleStartTagSchemaInformed(ruleContent2);
        ruleCurrent.joinRules(ruleContent);
        if (attributes != null && attributes.getLength() > 0) {
            Vector<XSAttributeUse> vSortedAttributes = XSDGrammarBuilder.getSortedAttributes(attributes);
            int i = vSortedAttributes.size() - 1;
            while (i >= 0) {
                XSAttributeUse attrUse = vSortedAttributes.elementAt(i);
                Attribute at = this.getAttributeEvent(attrUse);
                RuleStartTagSchemaInformed newCurrent = new RuleStartTagSchemaInformed(ruleContent2);
                newCurrent.addRule(at, ruleCurrent);
                if (!attrUse.getRequired()) {
                    newCurrent.joinRules(ruleCurrent);
                }
                ruleCurrent = newCurrent;
                --i;
            }
        }
        return ruleCurrent;
    }

    private void handleSubstitutionGroups(XSElementDeclaration xsElementDeclaration, SchemaInformedRule elementRule, SchemaInformedRule s) {
        XSObjectList xsSubstitutionGroups = this.xsModel.getSubstitutionGroup(xsElementDeclaration);
        if (xsSubstitutionGroups != null && xsSubstitutionGroups.getLength() > 0) {
            int i = 0;
            while (i < xsSubstitutionGroups.getLength()) {
                XSElementDeclaration xsSGElementDeclaration = (XSElementDeclaration)xsSubstitutionGroups.item(i);
                StartElement seSG = new StartElement(xsSGElementDeclaration.getNamespace(), xsSGElementDeclaration.getName());
                elementRule.addRule(seSG, s);
                ++i;
            }
        }
    }

    protected TypeGrammar getTypeGrammar(String namespaceURI, String name) {
        ExpandedName en = new ExpandedName(namespaceURI, name);
        return this.grammarTypes.get(en);
    }

    protected void translatElementDeclarationToFSA(XSElementDeclaration xsElementDeclaration, ExpandedName scope) {
        TypeGrammar typeGrammar;
        if (this.handledElements.contains(xsElementDeclaration)) {
            return;
        }
        this.handledElements.add(xsElementDeclaration);
        ExpandedName elementName = new ExpandedName(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName());
        this.addLocalNameStringEntry(elementName);
        this.enclosingElements.push(elementName);
        XSTypeDefinition td = xsElementDeclaration.getTypeDefinition();
        if (td.getAnonymous()) {
            typeGrammar = this.translateTypeDefinitionToFSA(td);
        } else {
            TypeGrammar tg = this.getTypeGrammar(td.getNamespace(), td.getName());
            SchemaInformedRule sir = tg.getType().duplicate();
            typeGrammar = new TypeGrammar(sir, tg.typeEmpty);
        }
        SchemaInformedRule type_i = typeGrammar.getType();
        SchemaInformedRule typeEmpty_i = typeGrammar.getTypeEmpty();
        type_i.setFirstElementRule();
        type_i.setNillable(xsElementDeclaration.getNillable(), typeEmpty_i);
        ExpandedName scopeType = null;
        XSComplexTypeDefinition enclosingType = xsElementDeclaration.getEnclosingCTDefinition();
        if (enclosingType != null && !enclosingType.getAnonymous()) {
            scopeType = new ExpandedName(enclosingType.getNamespace(), enclosingType.getName());
        }
        this.addRuleFor(elementName, scope, scopeType, type_i);
        this.enclosingElements.pop();
    }

    protected TypeGrammar translateTypeDefinitionToFSA(XSTypeDefinition td) {
        SchemaInformedRule type_i = null;
        SchemaInformedRule typeEmpty_i = null;
        if (td.getTypeCategory() == 15) {
            if ("anyType".equals(td.getName()) && "http://www.w3.org/2001/XMLSchema".equals(td.getNamespace())) {
                TypeGrammar urType = GrammarSchemaInformed.getUrTypeRule();
                type_i = urType.type;
                typeEmpty_i = urType.typeEmpty;
            } else {
                XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
                SchemaInformedRule ruleContent = this.translateComplexTypeDefinitionToFSA(ctd);
                ruleContent.resolveLambdaTransitions();
                SchemaInformedRule ruleContent2 = ruleContent.duplicate();
                XSObjectList attributes = ctd.getAttributeUses();
                type_i = this.handleAttributes(ruleContent, ruleContent2, attributes);
                type_i.setHasNamedSubtypes(this.hasNamedSubTypes((XSTypeDefinition)ctd));
                RuleElementSchemaInformed ruleEnd = new RuleElementSchemaInformed();
                ruleEnd.addTerminalRule(this.END_ELEMENT);
                typeEmpty_i = this.handleAttributes(ruleEnd, ruleEnd, attributes);
            }
        } else if (td.getTypeCategory() == 16) {
            XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)td;
            RuleElementSchemaInformed simpleContent = this.translateSimpleTypeDefinitionToFSA(std);
            type_i = this.handleAttributes(simpleContent, simpleContent, null);
            type_i.setHasNamedSubtypes(this.hasNamedSubTypes((XSTypeDefinition)std));
            RuleElementSchemaInformed ruleEnd = new RuleElementSchemaInformed();
            ruleEnd.addTerminalRule(this.END_ELEMENT);
            typeEmpty_i = this.handleAttributes(ruleEnd, ruleEnd, null);
        }
        if (!td.getAnonymous()) {
            ExpandedName typeName = new ExpandedName(td.getNamespace(), td.getName());
            this.addLocalNameStringEntry(typeName);
            this.ruleForType.put(typeName, type_i);
        }
        return new TypeGrammar(type_i, typeEmpty_i);
    }

    private boolean hasNamedSubTypes(XSTypeDefinition td) {
        XSNamedMap types = this.xsModel.getComponents((short)3);
        int i = 0;
        while (i < types.getLength()) {
            XSTypeDefinition td2 = (XSTypeDefinition)types.item(i);
            if (td.equals(td2.getBaseType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected SchemaInformedRule translateComplexTypeDefinitionToFSA(XSComplexTypeDefinition ctd) {
        SchemaInformedRule ruleContent = null;
        switch (ctd.getContentType()) {
            case 0: {
                ruleContent = new RuleElementSchemaInformed();
                ruleContent.addTerminalRule(this.END_ELEMENT);
                break;
            }
            case 1: {
                XSSimpleTypeDefinition std = ctd.getSimpleType();
                ruleContent = this.translateSimpleTypeDefinitionToFSA(std);
                break;
            }
            case 2: {
                XSParticle xsParticleElement = ctd.getParticle();
                RuleElementSchemaInformed ruleEE = new RuleElementSchemaInformed();
                ruleEE.addTerminalRule(this.END_ELEMENT);
                ruleContent = this.translateParticleToFSA(xsParticleElement, ruleEE);
                break;
            }
            case 3: {
                XSParticle xsParticleMixed = ctd.getParticle();
                RuleElementSchemaInformed ruleEE3 = new RuleElementSchemaInformed();
                ruleEE3.addTerminalRule(this.END_ELEMENT);
                ruleContent = this.translateParticleToFSA(xsParticleMixed, ruleEE3);
                this.addMixedTransitions(ruleContent);
                ruleContent.setLabel("MixedContent");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return ruleContent;
    }

    private void addMixedTransitions(Rule ruleMixedContent) {
        this.addMixedTransitions(ruleMixedContent, new ArrayList<Rule>());
    }

    private void addMixedTransitions(Rule ruleMixedContent, List<Rule> handled) {
        if (handled.contains(ruleMixedContent)) {
            return;
        }
        handled.add(ruleMixedContent);
        ruleMixedContent.addRule(new CharactersGeneric(), ruleMixedContent);
        int i = 0;
        while (i < ruleMixedContent.getNumberOfEvents()) {
            Rule r = ruleMixedContent.get1stLevelRule(i);
            if (!r.isTerminalRule()) {
                this.addMixedTransitions(r, handled);
            }
            ++i;
        }
    }

    protected RuleElementSchemaInformed translateSimpleTypeDefinitionToFSA(XSSimpleTypeDefinition std) {
        ExpandedName nameValueType = std.getAnonymous() ? new ExpandedName(null, "Anonymous") : new ExpandedName(std.getNamespace(), std.getName());
        Characters chSchemaValid = new Characters(nameValueType, BuiltIn.getDatatype(std));
        RuleElementSchemaInformed type_i_1 = new RuleElementSchemaInformed();
        RuleElementSchemaInformed type_i_0 = new RuleElementSchemaInformed();
        type_i_0.addRule(chSchemaValid, type_i_1);
        type_i_1.addTerminalRule(this.END_ELEMENT);
        return type_i_0;
    }

    protected SchemaInformedRule translateParticleToFSA(XSParticle particle, SchemaInformedRule s) {
        XSTerm xsTerm;
        SchemaInformedRule n = s;
        assert (particle != null);
        if (particle.getMaxOccursUnbounded()) {
            RuleElementSchemaInformed t = new RuleElementSchemaInformed();
            xsTerm = particle.getTerm();
            SchemaInformedRule b = this.translateTermToFSA(xsTerm, t);
            t.addRule(this.LAMBDA, b);
            b.addRule(this.LAMBDA, n);
            n = b;
        }
        if (!particle.getMaxOccursUnbounded()) {
            int numberOfCopies = particle.getMaxOccurs() - particle.getMinOccurs();
            int i = 0;
            while (i < numberOfCopies) {
                SchemaInformedRule ruleTerm;
                XSTerm xsTerm2 = particle.getTerm();
                n = ruleTerm = this.translateTermToFSA(xsTerm2, n);
                n.addRule(this.LAMBDA, s);
                ++i;
            }
        }
        int i = 0;
        while (i < particle.getMinOccurs()) {
            SchemaInformedRule ruleTerm;
            xsTerm = particle.getTerm();
            n = ruleTerm = this.translateTermToFSA(xsTerm, n);
            ++i;
        }
        return n;
    }

    protected SchemaInformedRule translateTermToFSA(XSTerm xsTerm, SchemaInformedRule s) {
        if (xsTerm instanceof XSElementDeclaration) {
            XSElementDeclaration xsElementDeclaration = (XSElementDeclaration)xsTerm;
            if (this.enclosingElements.peek() != null) {
                if (this.outstandingElements.contains(xsElementDeclaration)) {
                    this.outstandingElements.remove(xsElementDeclaration);
                }
                this.translatElementDeclarationToFSA(xsElementDeclaration, this.enclosingElements.peek());
            } else if (!this.outstandingElements.contains(xsElementDeclaration)) {
                this.outstandingElements.add(xsElementDeclaration);
            }
            if (!this.type4Element.containsKey(xsElementDeclaration)) {
                this.type4Element.put(xsElementDeclaration, xsElementDeclaration.getTypeDefinition());
            }
            RuleElementSchemaInformed ruleSubElement = new RuleElementSchemaInformed();
            StartElement se = new StartElement(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName());
            ruleSubElement.addRule(se, s);
            this.handleSubstitutionGroups(xsElementDeclaration, ruleSubElement, s);
            return ruleSubElement;
        }
        if (xsTerm instanceof XSModelGroup) {
            XSModelGroup xsModelGroup = (XSModelGroup)xsTerm;
            if (xsModelGroup.getCompositor() == 1) {
                XSObjectList particles = xsModelGroup.getParticles();
                SchemaInformedRule b = s;
                int k = particles.getLength() - 1;
                while (k >= 0) {
                    SchemaInformedRule ruleParticle;
                    XSParticle xsParticle = (XSParticle)particles.item(k);
                    b = ruleParticle = this.translateParticleToFSA(xsParticle, b);
                    --k;
                }
                return b;
            }
            if (xsModelGroup.getCompositor() == 2) {
                XSObjectList particles = xsModelGroup.getParticles();
                RuleElementSchemaInformed b = new RuleElementSchemaInformed();
                int i = 0;
                while (i < particles.getLength()) {
                    XSParticle xsParticle = (XSParticle)particles.item(i);
                    SchemaInformedRule ruleParticle = this.translateParticleToFSA(xsParticle, s);
                    b.joinRules(ruleParticle);
                    ++i;
                }
                return b;
            }
            if (xsModelGroup.getCompositor() == 3) {
                XSObjectList particles = xsModelGroup.getParticles();
                RuleContentAllSchemaInformed b = new RuleContentAllSchemaInformed();
                b.joinRules(s);
                int k = 0;
                while (k < particles.getLength()) {
                    XSParticle xsParticle = (XSParticle)particles.item(k);
                    SchemaInformedRule ruleParticle = this.translateParticleToFSA(xsParticle, b);
                    b.joinRules(ruleParticle);
                    ++k;
                }
                return b;
            }
            throw new RuntimeException("Unknown ModelGroup Compositor");
        }
        if (xsTerm instanceof XSWildcard) {
            XSWildcard xsWildcard = (XSWildcard)xsTerm;
            SchemaInformedRule b = s;
            SchemaInformedRule urType = GrammarSchemaInformed.getUrTypeRule().type;
            b.joinRules(urType);
            short constraintType = xsWildcard.getConstraintType();
            if (constraintType != 1) {
                // empty if block
            }
            return b;
        }
        throw new IllegalArgumentException("Unexpected XSTerm, neither ElementDeclaration, ModelGroup nor Wildcard");
    }
}

