/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.block;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.decoder.TypeDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoder;
import com.siemens.ct.exi.io.block.DecoderBlock;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractDecoderBlock
implements DecoderBlock {
    protected InputStream inputStream;
    protected TypeDecoder typeDecoder;

    public AbstractDecoderBlock(InputStream is, TypeDecoder typeDecoder) throws IOException {
        this.inputStream = is;
        this.typeDecoder = typeDecoder;
        this.init();
    }

    protected abstract void init() throws IOException;

    protected abstract DecoderChannel getStructureChannel();

    protected abstract DecoderChannel getValueChannel(String var1, String var2) throws IOException;

    public int readEventCode(int codeLength) throws IOException {
        return this.getStructureChannel().decodeNBitUnsignedInteger(codeLength);
    }

    public String readString() throws IOException {
        return this.getStructureChannel().decodeString();
    }

    public String readUri() throws IOException {
        String uri;
        StringTableDecoder stringTable;
        int mUri;
        int nUri;
        DecoderChannel structure = this.getStructureChannel();
        int uriID = structure.decodeNBitUnsignedInteger(nUri = MethodsBag.getCodingLength((mUri = (stringTable = this.typeDecoder.getStringTable()).getURITableSize()) + 1));
        if (uriID == 0) {
            uri = structure.decodeString();
            stringTable.addURI(uri);
        } else {
            uri = stringTable.getURIValue(uriID - 1);
        }
        return uri;
    }

    public String readLocalName(String uri) throws IOException {
        String localName;
        DecoderChannel structure = this.getStructureChannel();
        StringTableDecoder stringTable = this.typeDecoder.getStringTable();
        int length = structure.decodeUnsignedInteger();
        if (length > 0) {
            localName = structure.decodeStringOnly(--length);
            stringTable.addLocalName(uri, localName);
        } else {
            int n = MethodsBag.getCodingLength(stringTable.getLocalNameTableSize(uri));
            int localNameID = structure.decodeNBitUnsignedInteger(n);
            localName = stringTable.getLocalNameValue(uri, localNameID);
        }
        return localName;
    }

    public String readPrefix(String uri) throws IOException {
        String prefix;
        StringTableDecoder stringTable;
        int mPfx;
        int nPfx;
        DecoderChannel structure = this.getStructureChannel();
        int pfxID = structure.decodeNBitUnsignedInteger(nPfx = MethodsBag.getCodingLength((mPfx = (stringTable = this.typeDecoder.getStringTable()).getPrefixTableSize(uri)) + 1));
        if (pfxID == 0) {
            prefix = structure.decodeString();
            stringTable.addPrefix(uri, prefix);
        } else {
            prefix = stringTable.getPrefixValue(uri, pfxID - 1);
        }
        return prefix;
    }

    public boolean readBoolean() throws IOException {
        return this.getStructureChannel().decodeBoolean();
    }

    public String readTypedValidValue(Datatype datatype, String namespaceURI, String localName) throws IOException {
        return this.typeDecoder.readTypeValidValue(datatype, this.getValueChannel(namespaceURI, localName), namespaceURI, localName);
    }

    public String readValueAsString(String namespaceURI, String localName) throws IOException {
        return this.typeDecoder.readValueAsString(this.getValueChannel(namespaceURI, localName), namespaceURI, localName);
    }

    public void skipToNextByteBoundary() throws IOException {
    }

    public TypeDecoder getTypeDecoder() {
        return this.typeDecoder;
    }
}

