/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.BitInputStream;
import com.siemens.ct.exi.io.channel.AbstractDecoderChannel;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import java.io.IOException;
import java.io.InputStream;

public class BitDecoderChannel
extends AbstractDecoderChannel
implements DecoderChannel {
    protected BitInputStream istream;

    public BitDecoderChannel(InputStream is) {
        this.istream = new BitInputStream(is);
    }

    public void align() throws IOException {
        this.istream.align();
    }

    public int decode() throws IOException {
        return this.istream.readBits(8);
    }

    public int decodeNBitUnsignedInteger(int n) throws IOException {
        assert (n >= 0);
        if (n == 0) {
            return 0;
        }
        return this.istream.readBits(n);
    }

    public boolean decodeBoolean() throws IOException {
        return this.istream.readBit() == 1;
    }

    public byte[] decodeBinary() throws IOException {
        int length = this.decodeUnsignedInteger();
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)this.istream.readBits(8);
            ++i;
        }
        return result;
    }
}

