/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.AbstractDecoderChannel;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteDecoderChannel
extends AbstractDecoderChannel
implements DecoderChannel {
    protected InputStream is;

    public ByteDecoderChannel(InputStream istream) {
        this.is = new BufferedInputStream(istream);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public int decode() throws IOException {
        return this.is.read();
    }

    public boolean decodeBoolean() throws IOException {
        return this.is.read() != 0;
    }

    public byte[] decodeBinary() throws IOException {
        int length = this.decodeUnsignedInteger();
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)this.is.read();
            ++i;
        }
        return result;
    }

    public int decodeNBitUnsignedInteger(int n) throws IOException {
        assert (n >= 0);
        int bitsRead = 0;
        int result = 0;
        while (bitsRead < n) {
            result += this.is.read() << bitsRead;
            bitsRead += 8;
        }
        return result;
    }
}

