/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util.datatype;

import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.util.datatype.XSDInteger;

public class XSDDecimal {
    private boolean sign;
    private XSDInteger integral = XSDInteger.newInstance();
    private XSDInteger revFractional = XSDInteger.newInstance();

    private XSDDecimal() {
    }

    public static XSDDecimal newInstance() {
        return new XSDDecimal();
    }

    public boolean getSign() {
        return this.sign;
    }

    public XSDInteger getIntegral() {
        return this.integral;
    }

    public XSDInteger getReverseFractional() {
        return this.revFractional;
    }

    public void parse(String decimal) throws XMLParsingException {
        try {
            this.sign = false;
            if (decimal.charAt(0) == '-') {
                this.sign = true;
                decimal = decimal.substring(1);
            } else if (decimal.charAt(0) == '+') {
                decimal = decimal.substring(1);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new XMLParsingException(e.getMessage());
        }
        int decPoint = decimal.indexOf(46);
        if (decPoint == -1) {
            this.integral.parse(decimal);
            this.revFractional.setToIntegerValue(0);
        } else {
            this.integral.parse(decimal.substring(0, decPoint));
            this.revFractional.parse(new StringBuilder(decimal.substring(decPoint + 1, decimal.length())).reverse().toString());
        }
    }
}

