/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util.datatype;

import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.util.datatype.IntegerType;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDInteger
implements Comparable<XSDInteger> {
    private int iInt;
    private long lInt;
    private BigInteger bInt;
    private IntegerType type;
    private XSDInteger subtractValue;

    private XSDInteger() {
    }

    public static XSDInteger newInstance() {
        return new XSDInteger();
    }

    public void setToIntegerValue(int val) {
        this.iInt = val;
        this.type = IntegerType.INT_INTEGER;
    }

    public void parse(String s) throws XMLParsingException {
        try {
            this.iInt = Integer.parseInt(s);
            this.type = IntegerType.INT_INTEGER;
        }
        catch (NumberFormatException e) {
            try {
                this.lInt = Long.parseLong(s);
                this.type = IntegerType.LONG_INTEGER;
            }
            catch (NumberFormatException el) {
                try {
                    this.bInt = new BigInteger(s);
                    this.type = IntegerType.BIG_INTEGER;
                }
                catch (NumberFormatException eb) {
                    throw new XMLParsingException("'" + s + "' cannot be parsed as Integer");
                }
            }
        }
    }

    public boolean isNegative() {
        switch (this.type) {
            case INT_INTEGER: {
                return this.iInt < 0;
            }
            case LONG_INTEGER: {
                return this.lInt < 0L;
            }
            case BIG_INTEGER: {
                return this.bInt.signum() < 0;
            }
        }
        throw new RuntimeException();
    }

    public int getIntInteger() {
        return this.iInt;
    }

    public long getLongInteger() {
        return this.lInt;
    }

    public BigInteger getBigInteger() {
        return this.bInt;
    }

    public IntegerType getIntegerType() {
        return this.type;
    }

    public XSDInteger subtract(XSDInteger val) {
        if (this.subtractValue == null) {
            this.subtractValue = XSDInteger.newInstance();
        }
        if (this.type == IntegerType.INT_INTEGER && val.type == IntegerType.INT_INTEGER) {
            this.subtractValue.iInt = this.iInt - val.iInt;
            this.subtractValue.type = IntegerType.INT_INTEGER;
            return this.subtractValue;
        }
        if (this.type == IntegerType.LONG_INTEGER && val.type == IntegerType.LONG_INTEGER) {
            this.subtractValue.lInt = this.lInt - val.lInt;
            this.subtractValue.type = IntegerType.LONG_INTEGER;
            return this.subtractValue;
        }
        if (this.type == IntegerType.BIG_INTEGER && val.type == IntegerType.BIG_INTEGER) {
            this.subtractValue.bInt = this.bInt.subtract(val.bInt);
            this.subtractValue.type = IntegerType.BIG_INTEGER;
            return this.subtractValue;
        }
        BigInteger thiss = new BigInteger(this.toString());
        BigInteger vall = new BigInteger(val.toString());
        this.subtractValue.bInt = thiss.subtract(vall);
        this.subtractValue.type = IntegerType.BIG_INTEGER;
        return this.subtractValue;
    }

    @Override
    public int compareTo(XSDInteger other) {
        if (this.type == IntegerType.INT_INTEGER && other.type == IntegerType.INT_INTEGER) {
            return this.iInt < other.iInt ? -1 : (this.iInt == other.iInt ? 0 : 1);
        }
        if (this.type == IntegerType.LONG_INTEGER && other.type == IntegerType.LONG_INTEGER) {
            return this.lInt < other.lInt ? -1 : (this.lInt == other.lInt ? 0 : 1);
        }
        if (this.type == IntegerType.BIG_INTEGER && other.type == IntegerType.BIG_INTEGER) {
            return this.bInt.compareTo(other.bInt);
        }
        if (this.type == IntegerType.INT_INTEGER && (other.type == IntegerType.LONG_INTEGER || other.type == IntegerType.BIG_INTEGER)) {
            return -1;
        }
        if (this.type == IntegerType.LONG_INTEGER) {
            return other.type == IntegerType.INT_INTEGER ? 1 : 0;
        }
        return 1;
    }

    public String toString() {
        if (this.type == IntegerType.INT_INTEGER) {
            return String.valueOf(this.iInt);
        }
        if (this.type == IntegerType.LONG_INTEGER) {
            return String.valueOf(this.lInt);
        }
        return this.bInt.toString();
    }
}

