/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;

public class EnumerationDatatype
extends AbstractDatatype {
    private int lastOrdinalPosition;
    private StringList enumValuesSL;
    private Value[] enumValuesCH;
    private int codingLength;

    public EnumerationDatatype(StringList enumValues) {
        super(BuiltInType.ENUMERATION, null);
        this.rcs = null;
        this.enumValuesSL = enumValues;
        this.enumValuesCH = new Value[enumValues.getLength()];
        int i = 0;
        while (i < enumValues.getLength()) {
            this.enumValuesCH[i] = new StringValue(enumValues.item(i).toCharArray());
            ++i;
        }
        this.codingLength = MethodsBag.getCodingLength(enumValues.getLength());
    }

    public String getEnumerationValueAsString(int index) {
        return this.enumValuesSL.item(index);
    }

    public Value getEnumerationValueAsCharArray(int index) {
        return this.enumValuesCH[index];
    }

    public int getEnumerationSize() {
        return this.enumValuesCH.length;
    }

    public int getCodingLength() {
        return this.codingLength;
    }

    public boolean isValid(String value) {
        this.lastOrdinalPosition = -1;
        int index = 0;
        while (index < this.enumValuesCH.length) {
            if (this.getEnumerationValueAsString(index).equals(value)) {
                this.lastOrdinalPosition = index;
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean isValidRCS(String value) {
        this.lastRCSValue = value;
        return true;
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastOrdinalPosition, this.codingLength);
    }

    public void writeValueRCS(RestrictedCharacterSetDatatype rcsEncoder, EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        stringEncoder.writeValue(context, valueChannel, this.lastRCSValue);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int index = valueChannel.decodeNBitUnsignedInteger(this.codingLength);
        return this.getEnumerationValueAsCharArray(index);
    }

    public Value readValueRCS(RestrictedCharacterSetDatatype rcsDecoder, DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return stringDecoder.readValue(context, valueChannel);
    }
}

