/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.EventInformation;
import com.siemens.ct.exi.grammar.GrammarURIEntry;
import com.siemens.ct.exi.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.AttributeNS;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.CharactersGeneric;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedElement;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedStartTag;
import com.siemens.ct.exi.types.BuiltIn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.xs.models.EXIContentModelBuilder;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGrammarBuilder
extends EXIContentModelBuilder {
    protected Map<QName, TypeGrammar> grammarTypes;
    protected Map<String, List<String>> schemaLocalNames;
    protected Set<XSElementDeclaration> handledElements;
    protected Map<XSAttributeDeclaration, Attribute> attributePool;

    protected XSDGrammarBuilder() {
        this.initOnce();
    }

    public static XSDGrammarBuilder newInstance() {
        return new XSDGrammarBuilder();
    }

    @Override
    protected void initOnce() {
        super.initOnce();
        this.handledElements = new HashSet<XSElementDeclaration>();
        this.grammarTypes = new HashMap<QName, TypeGrammar>();
        this.schemaLocalNames = new HashMap<String, List<String>>();
        this.attributePool = new HashMap<XSAttributeDeclaration, Attribute>();
    }

    @Override
    protected void initEachRun() {
        super.initEachRun();
        this.handledElements.clear();
        this.grammarTypes.clear();
        this.schemaLocalNames.clear();
        this.attributePool.clear();
    }

    protected boolean isSameGrammar(List<XSElementDeclaration> elements) {
        assert (elements.size() > 1);
        int i = 1;
        while (i < elements.size()) {
            XSElementDeclaration e0 = elements.get(0);
            XSElementDeclaration ei = elements.get(i);
            if (e0.getTypeDefinition() != ei.getTypeDefinition() || e0.getNillable() != ei.getNillable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List<StartElement> getFragmentGrammars() {
        ArrayList<StartElement> fragmentElements = new ArrayList<StartElement>();
        HashMap namedElements = new HashMap();
        for (XSElementDeclaration elDecl : this.handledElements) {
            QName en = new QName(elDecl.getNamespace(), elDecl.getName());
            if (namedElements.containsKey(en)) {
                ((List)namedElements.get(en)).add(elDecl);
                continue;
            }
            ArrayList<XSElementDeclaration> list = new ArrayList<XSElementDeclaration>();
            list.add(elDecl);
            namedElements.put(en, list);
        }
        for (Map.Entry e : namedElements.entrySet()) {
            QName qname = (QName)e.getKey();
            List elements = (List)e.getValue();
            assert (elements.size() >= 1);
            if (elements.size() == 1) {
                fragmentElements.add(this.getStartElement((XSElementDeclaration)elements.get(0)));
                continue;
            }
            if (this.isSameGrammar(elements)) {
                fragmentElements.add(this.getStartElement((XSElementDeclaration)elements.get(0)));
                continue;
            }
            StartElement se = new StartElement(qname);
            se.setRule(this.getSchemaInformedElementFragmentGrammar(elements));
            fragmentElements.add(se);
        }
        return fragmentElements;
    }

    protected Rule getSchemaInformedElementFragmentGrammar(List<XSElementDeclaration> elements) {
        SchemaInformedElement content = new SchemaInformedElement();
        content.addRule(START_ELEMENT_GENERIC, content);
        content.addTerminalRule(END_ELEMENT);
        content.addRule(CHARACTERS_GENERIC, content);
        SchemaInformedStartTag startTag = new SchemaInformedStartTag(content);
        startTag.addRule(ATTRIBUTE_GENERIC, startTag);
        startTag.addRule(START_ELEMENT_GENERIC, content);
        startTag.addTerminalRule(END_ELEMENT);
        startTag.addRule(CHARACTERS_GENERIC, content);
        SchemaInformedStartTag typeEmpty = startTag;
        startTag.setFirstElementRule();
        startTag.setNillable(true, typeEmpty);
        startTag.setTypeCastable(true);
        return startTag;
    }

    public SchemaInformedGrammar toGrammar() throws EXIException {
        if (this.xsModel == null || this.schemaParsingErrors.size() > 0) {
            StringBuffer sb = new StringBuffer("Problem occured while building XML Schema Model (XSModel)!");
            int i = 0;
            while (i < this.schemaParsingErrors.size()) {
                sb.append("\n. " + (String)this.schemaParsingErrors.get(i));
                ++i;
            }
            throw new EXIException(sb.toString());
        }
        List<StartElement> globalElements = this.initGrammars();
        List<StartElement> fragmentElements = this.getFragmentGrammars();
        Collections.sort(globalElements, lexSort);
        Collections.sort(fragmentElements, lexSort);
        String[] sortedURIs = this.initURITableEntries();
        GrammarURIEntry[] additionalSchemaEntries = new GrammarURIEntry[sortedURIs.length];
        int i = 0;
        while (i < sortedURIs.length) {
            String[] localNamesArray;
            String uri = sortedURIs[i];
            if (this.schemaLocalNames.containsKey(uri)) {
                List<String> localNames = this.schemaLocalNames.get(uri);
                Collections.sort(localNames);
                localNamesArray = new String[localNames.size()];
                localNames.toArray(localNamesArray);
            } else {
                localNamesArray = new String[]{};
            }
            additionalSchemaEntries[i] = new GrammarURIEntry(uri, localNamesArray, null);
            ++i;
        }
        SchemaInformedGrammar sig = new SchemaInformedGrammar(additionalSchemaEntries, fragmentElements, globalElements);
        sig.setTypeGrammars(this.grammarTypes);
        XSNamedMap nm = this.xsModel.getComponents((short)1);
        HashMap<QName, Attribute> globalAttributes = new HashMap<QName, Attribute>();
        int i2 = 0;
        while (i2 < nm.getLength()) {
            XSAttributeDeclaration atDecl = (XSAttributeDeclaration)nm.item(i2);
            Attribute at = this.getAttribute(atDecl);
            globalAttributes.put(at.getQName(), at);
            ++i2;
        }
        sig.setGlobalAttributes(globalAttributes);
        return sig;
    }

    protected static boolean isNamespacesOfInterest(String namespaceURI) {
        assert (namespaceURI != null);
        return !namespaceURI.equals("http://www.w3.org/XML/1998/namespace") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema");
    }

    protected String[] initURITableEntries() {
        StringList namespaces = this.xsModel.getNamespaces();
        TreeSet<String> sortedURIs = new TreeSet<String>();
        int i = 0;
        while (i < namespaces.getLength()) {
            String uri;
            String string = uri = namespaces.item(i) == null ? "" : namespaces.item(i);
            if (XSDGrammarBuilder.isNamespacesOfInterest(uri)) {
                sortedURIs.add(uri);
            }
            ++i;
        }
        if (!sortedURIs.contains("")) {
            sortedURIs.add("");
        }
        String[] uris = new String[sortedURIs.size()];
        sortedURIs.toArray(uris);
        return uris;
    }

    protected void addLocalNameStringEntry(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (XSDGrammarBuilder.isNamespacesOfInterest(namespaceURI)) {
            List<Object> localNameList;
            if (this.schemaLocalNames.containsKey(namespaceURI)) {
                localNameList = this.schemaLocalNames.get(namespaceURI);
            } else {
                localNameList = new ArrayList();
                this.schemaLocalNames.put(namespaceURI, localNameList);
            }
            if (!localNameList.contains(localName)) {
                localNameList.add(localName);
            }
        }
    }

    protected List<StartElement> initGrammars() throws EXIException {
        ArrayList<StartElement> globalElements = new ArrayList<StartElement>();
        XSNamedMap types = this.xsModel.getComponents((short)3);
        int i = 0;
        while (i < types.getLength()) {
            XSTypeDefinition td = (XSTypeDefinition)types.item(i);
            QName name = new QName(td.getNamespace(), td.getName());
            TypeGrammar typeGrammar = this.translateTypeDefinitionToFSA(td);
            this.grammarTypes.put(name, typeGrammar);
            ++i;
        }
        XSNamedMap xsGlobalElements = this.xsModel.getComponents((short)2);
        int i2 = 0;
        while (i2 < xsGlobalElements.getLength()) {
            XSElementDeclaration globalElementDecl = (XSElementDeclaration)xsGlobalElements.item(i2);
            StartElement seGlobalElement = this.getStartElement(globalElementDecl);
            globalElements.add(seGlobalElement);
            this.translatElementDeclarationToFSA(globalElementDecl);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.remainingElements.size()) {
            XSElementDeclaration remElement = (XSElementDeclaration)this.remainingElements.get(i2);
            this.translatElementDeclarationToFSA(remElement);
            ++i2;
        }
        for (XSElementDeclaration elementDecl : this.elementPool.keySet()) {
            SchemaInformedRule elementRule;
            TypeGrammar typeGrammar;
            StartElement se = (StartElement)this.elementPool.get(elementDecl);
            XSTypeDefinition td = elementDecl.getTypeDefinition();
            if (td.getAnonymous()) {
                typeGrammar = this.translateTypeDefinitionToFSA(td);
                elementRule = typeGrammar.getType();
                elementRule.setNillable(elementDecl.getNillable(), typeGrammar.getTypeEmpty());
            } else {
                typeGrammar = this.getTypeGrammar(td.getNamespace(), td.getName());
                elementRule = typeGrammar.getType();
                if (elementDecl.getNillable()) {
                    elementRule = elementRule.duplicate();
                    elementRule.setNillable(true, typeGrammar.getTypeEmpty());
                } else {
                    elementRule.setNillable(false, typeGrammar.getTypeEmpty());
                }
            }
            se.setRule(elementRule);
        }
        return globalElements;
    }

    protected Attribute getAttribute(XSAttributeDeclaration attrDecl) throws EXIException {
        Attribute at;
        this.addLocalNameStringEntry(attrDecl.getNamespace(), attrDecl.getName());
        if (this.attributePool.containsKey(attrDecl)) {
            at = this.attributePool.get(attrDecl);
        } else {
            XSTypeDefinition tdBase;
            XSSimpleTypeDefinition attrTypeDefinition = attrDecl.getTypeDefinition();
            QName qNameType = attrTypeDefinition.getAnonymous() ? ((tdBase = attrTypeDefinition.getBaseType()).getName() == null ? BuiltIn.DEFAULT_VALUE_NAME : new QName(tdBase.getNamespace(), tdBase.getName())) : new QName(attrTypeDefinition.getNamespace(), attrTypeDefinition.getName());
            QName qname = new QName(attrDecl.getNamespace(), attrDecl.getName());
            at = new Attribute(qname, qNameType, BuiltIn.getDatatype(attrTypeDefinition));
            this.attributePool.put(attrDecl, at);
        }
        return at;
    }

    protected SchemaInformedRule handleAttributes(SchemaInformedRule ruleContent, SchemaInformedRule ruleContent2, XSObjectList attributes, XSWildcard attributeWC) throws EXIException {
        SchemaInformedStartTag ruleStart = new SchemaInformedStartTag(ruleContent2);
        int i = 0;
        while (i < ruleContent.getNumberOfEvents()) {
            EventInformation ei = ruleContent.lookFor(i);
            ruleStart.addRule(ei.event, ei.next);
            ++i;
        }
        if (attributeWC != null) {
            ruleStart.addTerminalRule(END_ELEMENT);
            this.handleAttributeWildCard(attributeWC, ruleStart);
        }
        if (attributes != null && attributes.getLength() > 0) {
            XSAttributeUse attrUse;
            ArrayList<XSAttributeUse> vSortedAttributes = new ArrayList<XSAttributeUse>();
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                assert (attributes.item(i2).getType() == 4);
                attrUse = (XSAttributeUse)attributes.item(i2);
                vSortedAttributes.add(attrUse);
                ++i2;
            }
            Collections.sort(vSortedAttributes, lexSort);
            i2 = vSortedAttributes.size() - 1;
            while (i2 >= 0) {
                attrUse = (XSAttributeUse)vSortedAttributes.get(i2);
                Attribute at = this.getAttribute(attrUse.getAttrDeclaration());
                SchemaInformedStartTag newCurrent = new SchemaInformedStartTag(ruleContent2);
                newCurrent.addRule(at, ruleStart);
                if (attributeWC != null) {
                    this.handleAttributeWildCard(attributeWC, newCurrent);
                }
                if (!attrUse.getRequired()) {
                    int k = 0;
                    while (k < ruleStart.getNumberOfEvents()) {
                        EventInformation ei = ruleStart.lookFor(k);
                        if (!ei.event.isEventType(EventType.ATTRIBUTE_GENERIC)) {
                            newCurrent.addRule(ei.event, ei.next);
                        }
                        ++k;
                    }
                }
                ruleStart = newCurrent;
                --i2;
            }
        }
        return ruleStart;
    }

    protected void handleAttributeWildCard(XSWildcard attributeWC, SchemaInformedRule rule) {
        short constraintType = attributeWC.getConstraintType();
        if (constraintType == 1 || constraintType == 2) {
            rule.addRule(ATTRIBUTE_GENERIC, rule);
        } else {
            StringList sl = attributeWC.getNsConstraintList();
            int k = 0;
            while (k < sl.getLength()) {
                rule.addRule(new AttributeNS(sl.item(k)), rule);
                ++k;
            }
        }
    }

    protected TypeGrammar getTypeGrammar(String namespaceURI, String name) {
        QName en = new QName(namespaceURI, name);
        return this.grammarTypes.get(en);
    }

    protected void translatElementDeclarationToFSA(XSElementDeclaration xsElementDeclaration) throws EXIException {
        if (this.handledElements.contains(xsElementDeclaration)) {
            return;
        }
        this.handledElements.add(xsElementDeclaration);
        this.addLocalNameStringEntry(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName());
        XSTypeDefinition td = xsElementDeclaration.getTypeDefinition();
        if (td.getAnonymous()) {
            this.translateTypeDefinitionToFSA(td);
        }
    }

    public static TypeGrammar getUrTypeRule() {
        SchemaInformedElement urType1 = new SchemaInformedElement();
        urType1.setLabel("any");
        urType1.addRule(START_ELEMENT_GENERIC, urType1);
        urType1.addTerminalRule(END_ELEMENT);
        urType1.addRule(new CharactersGeneric(), urType1);
        SchemaInformedStartTag urType0 = new SchemaInformedStartTag(urType1);
        urType0.addRule(ATTRIBUTE_GENERIC, urType0);
        urType0.addRule(START_ELEMENT_GENERIC, urType1);
        urType0.addTerminalRule(END_ELEMENT);
        urType0.addRule(new CharactersGeneric(), urType1);
        urType0.setTypeCastable(true);
        urType0.setFirstElementRule();
        SchemaInformedElement emptyUrType0 = new SchemaInformedElement();
        emptyUrType0.addRule(ATTRIBUTE_GENERIC, emptyUrType0);
        emptyUrType0.addTerminalRule(END_ELEMENT);
        urType0.setNillable(false, emptyUrType0);
        return new TypeGrammar(urType0, emptyUrType0);
    }

    protected TypeGrammar translateTypeDefinitionToFSA(XSTypeDefinition td) throws EXIException {
        SchemaInformedRule type_i = null;
        SchemaInformedRule typeEmpty_i = null;
        if (td.getTypeCategory() == 15) {
            if ("anyType".equals(td.getName()) && "http://www.w3.org/2001/XMLSchema".equals(td.getNamespace())) {
                TypeGrammar urType = XSDGrammarBuilder.getUrTypeRule();
                type_i = urType.type;
                typeEmpty_i = urType.typeEmpty;
            } else {
                XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
                SchemaInformedRule ruleContent = this.translateComplexTypeDefinitionToFSA(ctd);
                SchemaInformedRule ruleContent2 = ruleContent.duplicate();
                XSObjectList attributes = ctd.getAttributeUses();
                XSWildcard attributeWC = ctd.getAttributeWildcard();
                type_i = this.handleAttributes(ruleContent, ruleContent2, attributes, attributeWC);
                type_i.setTypeCastable(this.isTypeCastable((XSTypeDefinition)ctd));
                SchemaInformedElement ruleEnd = new SchemaInformedElement();
                ruleEnd.addTerminalRule(END_ELEMENT);
                typeEmpty_i = this.handleAttributes(ruleEnd, ruleEnd, attributes, attributeWC);
            }
        } else {
            assert (td.getTypeCategory() == 16);
            XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)td;
            SchemaInformedElement simpleContent = this.translateSimpleTypeDefinitionToFSA(std);
            type_i = this.handleAttributes(simpleContent, simpleContent, null, null);
            type_i.setTypeCastable(this.isTypeCastable((XSTypeDefinition)std));
            SchemaInformedElement ruleEnd = new SchemaInformedElement();
            ruleEnd.addTerminalRule(END_ELEMENT);
            typeEmpty_i = this.handleAttributes(ruleEnd, ruleEnd, null, null);
        }
        if (!td.getAnonymous()) {
            this.addLocalNameStringEntry(td.getNamespace(), td.getName());
        }
        type_i.setFirstElementRule();
        return new TypeGrammar(type_i, typeEmpty_i);
    }

    protected boolean isTypeCastable(XSTypeDefinition td) {
        boolean isTypeCastable = false;
        XSNamedMap types = this.xsModel.getComponents((short)3);
        int i = 0;
        while (i < types.getLength()) {
            XSTypeDefinition td2 = (XSTypeDefinition)types.item(i);
            if (td.equals(td2.getBaseType())) {
                isTypeCastable = true;
            }
            ++i;
        }
        if (!isTypeCastable && td.getTypeCategory() == 16) {
            XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)td;
            isTypeCastable = std.getVariety() == 3;
        }
        return isTypeCastable;
    }

    protected SchemaInformedRule translateComplexTypeDefinitionToFSA(XSComplexTypeDefinition ctd) throws EXIException {
        SchemaInformedRule ruleContent = null;
        switch (ctd.getContentType()) {
            case 0: {
                ruleContent = new SchemaInformedElement();
                ruleContent.addTerminalRule(END_ELEMENT);
                break;
            }
            case 1: {
                XSSimpleTypeDefinition std = ctd.getSimpleType();
                ruleContent = this.translateSimpleTypeDefinitionToFSA(std);
                break;
            }
            case 2: {
                boolean isMixedContent = false;
                ruleContent = this.handleParticle(ctd, isMixedContent);
                break;
            }
            default: {
                assert (ctd.getContentType() == 3);
                boolean isMixedContent = true;
                ruleContent = this.handleParticle(ctd, isMixedContent);
            }
        }
        return ruleContent;
    }

    protected SchemaInformedElement translateSimpleTypeDefinitionToFSA(XSSimpleTypeDefinition std) throws EXIException {
        QName nameValueType = std.getAnonymous() ? new QName(null, "Anonymous") : new QName(std.getNamespace(), std.getName());
        Characters chSchemaValid = new Characters(nameValueType, BuiltIn.getDatatype(std));
        SchemaInformedElement type_i_1 = new SchemaInformedElement();
        SchemaInformedElement type_i_0 = new SchemaInformedElement();
        type_i_0.addRule(chSchemaValid, type_i_1);
        type_i_1.addTerminalRule(END_ELEMENT);
        return type_i_0;
    }
}

