/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.helpers;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.GrammarFactory;
import com.siemens.ct.exi.api.sax.EXIWriter;
import com.siemens.ct.exi.core.EXIDecoderInOrder;
import com.siemens.ct.exi.core.EXIDecoderInOrderSC;
import com.siemens.ct.exi.core.EXIDecoderReordered;
import com.siemens.ct.exi.core.EXIEncoderInOrder;
import com.siemens.ct.exi.core.EXIEncoderInOrderSC;
import com.siemens.ct.exi.core.EXIEncoderReordered;
import com.siemens.ct.exi.core.sax.SAXDecoder;
import com.siemens.ct.exi.core.sax.SAXDecoderExtendedHandler;
import com.siemens.ct.exi.core.sax.SAXEncoder;
import com.siemens.ct.exi.core.sax.SAXEncoderExtendedHandler;
import com.siemens.ct.exi.datatype.strings.StringDecoderImpl;
import com.siemens.ct.exi.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.types.AbstractTypeDecoder;
import com.siemens.ct.exi.types.AbstractTypeEncoder;
import com.siemens.ct.exi.types.DatatypeRepresentation;
import com.siemens.ct.exi.types.DatatypeRepresentationMapTypeDecoder;
import com.siemens.ct.exi.types.DatatypeRespresentationMapTypeEncoder;
import com.siemens.ct.exi.types.LexicalTypeDecoder;
import com.siemens.ct.exi.types.LexicalTypeEncoder;
import com.siemens.ct.exi.types.StringTypeDecoder;
import com.siemens.ct.exi.types.StringTypeEncoder;
import com.siemens.ct.exi.types.TypeDecoder;
import com.siemens.ct.exi.types.TypeEncoder;
import com.siemens.ct.exi.types.TypedTypeDecoder;
import com.siemens.ct.exi.types.TypedTypeEncoder;
import javax.xml.namespace.QName;
import org.xml.sax.XMLReader;

public class DefaultEXIFactory
implements EXIFactory {
    protected Grammar grammar;
    protected boolean isFragment;
    protected CodingMode codingMode;
    protected FidelityOptions fidelityOptions;
    protected DatatypeRepresentation[] userDefinedDatatypeRepresentations;
    protected QName[] scElements;
    protected boolean exiBodyOnly = false;

    protected DefaultEXIFactory() {
    }

    protected static void setDefaultValues(EXIFactory factory) {
        factory.setFidelityOptions(FidelityOptions.createDefault());
        factory.setCodingMode(CodingMode.BIT_PACKED);
        factory.setFragment(false);
        factory.setGrammar(GrammarFactory.newInstance().createSchemaLessGrammar());
    }

    public static EXIFactory newInstance() {
        DefaultEXIFactory factory = new DefaultEXIFactory();
        DefaultEXIFactory.setDefaultValues(factory);
        return factory;
    }

    public void setFidelityOptions(FidelityOptions fidelityOptions) {
        this.fidelityOptions = fidelityOptions;
    }

    public FidelityOptions getFidelityOptions() {
        return this.fidelityOptions;
    }

    public void setDatatypeRepresentationMap(DatatypeRepresentation[] datatypeRepresentations) {
        this.userDefinedDatatypeRepresentations = datatypeRepresentations;
    }

    public void setSelfContainedElements(QName[] scElements) {
        this.scElements = scElements;
    }

    public boolean isSelfContainedElement(QName element) {
        if (this.scElements != null && this.scElements.length > 0) {
            QName[] qNameArray = this.scElements;
            int n = this.scElements.length;
            int n2 = 0;
            while (n2 < n) {
                QName qname = qNameArray[n2];
                if (qname.equals(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setGrammar(Grammar grammar) {
        assert (grammar != null);
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    protected boolean isSchemaInformed() {
        return this.grammar.isSchemaInformed();
    }

    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setCodingMode(CodingMode codingMode) {
        this.codingMode = codingMode;
    }

    public CodingMode getCodingMode() {
        return this.codingMode;
    }

    public void setEXIBodyOnly(boolean exiBodyOnly) {
        this.exiBodyOnly = exiBodyOnly;
    }

    public boolean isEXIBodyOnly() {
        return this.exiBodyOnly;
    }

    public EXIEncoder createEXIEncoder() {
        if (this.codingMode.usesRechanneling()) {
            return new EXIEncoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIEncoderInOrderSC(this);
        }
        return new EXIEncoderInOrder(this);
    }

    public EXIWriter createEXIWriter() {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") || this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXEncoderExtendedHandler(this);
        }
        return new SAXEncoder(this);
    }

    public EXIDecoder createEXIDecoder() {
        if (this.codingMode.usesRechanneling()) {
            return new EXIDecoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIDecoderInOrderSC(this);
        }
        return new EXIDecoderInOrder(this);
    }

    public XMLReader createEXIReader() {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") || this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXDecoderExtendedHandler(this);
        }
        return new SAXDecoder(this);
    }

    public TypeEncoder createTypeEncoder() {
        AbstractTypeEncoder typeEncoder;
        StringEncoderImpl stringEncoder = new StringEncoderImpl();
        if (this.isSchemaInformed()) {
            if (this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                typeEncoder = new LexicalTypeEncoder(stringEncoder);
            } else if (this.userDefinedDatatypeRepresentations != null && this.userDefinedDatatypeRepresentations.length > 0) {
                DatatypeRespresentationMapTypeEncoder enc = new DatatypeRespresentationMapTypeEncoder(stringEncoder);
                int i = 0;
                while (i < this.userDefinedDatatypeRepresentations.length) {
                    enc.registerDatatypeRepresentation(this.userDefinedDatatypeRepresentations[i]);
                    ++i;
                }
                typeEncoder = enc;
            } else {
                typeEncoder = new TypedTypeEncoder(stringEncoder);
            }
        } else {
            typeEncoder = new StringTypeEncoder(stringEncoder);
        }
        return typeEncoder;
    }

    public TypeDecoder createTypeDecoder() {
        AbstractTypeDecoder typeDecoder;
        StringDecoderImpl stringDecoder = new StringDecoderImpl();
        if (this.isSchemaInformed()) {
            if (this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                typeDecoder = new LexicalTypeDecoder(stringDecoder);
            } else if (this.userDefinedDatatypeRepresentations != null && this.userDefinedDatatypeRepresentations.length > 0) {
                DatatypeRepresentationMapTypeDecoder dec = new DatatypeRepresentationMapTypeDecoder(stringDecoder);
                int i = 0;
                while (i < this.userDefinedDatatypeRepresentations.length) {
                    dec.registerDatatypeRepresentation(this.userDefinedDatatypeRepresentations[i]);
                    ++i;
                }
                typeDecoder = dec;
            } else {
                typeDecoder = new TypedTypeDecoder(stringDecoder);
            }
        } else {
            typeDecoder = new StringTypeDecoder(stringDecoder);
        }
        return typeDecoder;
    }

    public EXIFactory clone() {
        EXIFactory copy = DefaultEXIFactory.newInstance();
        copy.setCodingMode(this.codingMode);
        copy.setDatatypeRepresentationMap(this.userDefinedDatatypeRepresentations);
        copy.setEXIBodyOnly(this.exiBodyOnly);
        copy.setFidelityOptions(this.fidelityOptions);
        copy.setFragment(this.isFragment);
        copy.setGrammar(this.grammar);
        copy.setSelfContainedElements(this.scElements);
        return copy;
    }
}

