/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util.datatype;

public class XSDFloat {
    public int mantissa;
    public int exponent;

    protected XSDFloat() {
    }

    public static XSDFloat newInstance() {
        return new XSDFloat();
    }

    public boolean parse(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (s.equals("INF")) {
            this.mantissa = 1;
            this.exponent = -16384;
        } else if (s.equals("-INF")) {
            this.mantissa = -1;
            this.exponent = -16384;
        } else if (s.equals("NaN")) {
            this.mantissa = 0;
            this.exponent = -16384;
        } else {
            char[] chars = s.toCharArray();
            int decimalDigits = 0;
            int len = chars.length;
            int pos = 0;
            this.mantissa = 0;
            this.exponent = 0;
            boolean negative = false;
            boolean negativeExponent = false;
            char c = chars[pos];
            if (c == '+') {
                ++pos;
            } else if (c == '-') {
                negative = true;
                ++pos;
            }
            while (pos < len && (c = chars[pos++]) != '.' && c != 'e' && c != 'E') {
                if (c == '0') {
                    this.mantissa *= 10;
                    continue;
                }
                if (c > '0' && c <= '9') {
                    this.mantissa = 10 * this.mantissa + (c - 48);
                    continue;
                }
                return false;
            }
            if (c == '.') {
                while (pos < len && (c = chars[pos++]) != 'e' && c != 'E') {
                    if (c == '0') {
                        this.mantissa *= 10;
                        ++decimalDigits;
                        continue;
                    }
                    if (c > '0' && c <= '9') {
                        this.mantissa = 10 * this.mantissa + (c - 48);
                        ++decimalDigits;
                        continue;
                    }
                    return false;
                }
            }
            if (c == 'e' || c == 'E') {
                c = chars[pos];
                if (c == '-') {
                    negativeExponent = true;
                    ++pos;
                } else if (c == '+') {
                    ++pos;
                }
                while (pos < len) {
                    if ((c = chars[pos++]) >= '0' && c <= '9') {
                        this.exponent = 10 * this.exponent + (c - 48);
                        continue;
                    }
                    return false;
                }
                if (negativeExponent) {
                    this.exponent = -this.exponent;
                }
            }
            if (pos != len) {
                return false;
            }
            this.exponent -= decimalDigits;
            if (negative) {
                this.mantissa = -this.mantissa;
            }
            if (this.mantissa == 0) {
                this.exponent = 0;
            }
        }
        return true;
    }
}

