/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xpath.regex.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXIRegularExpression
extends RegularExpression {
    public static final int MAX_NUMBER_OF_CHARACTERS = 255;
    private static final long serialVersionUID = 1L;
    protected Set<Integer> set = new HashSet<Integer>();
    protected boolean isRestrictedSet = true;

    public EXIRegularExpression(String regex) {
        super(regex, "X");
        this.handleToken(this.tokentree, this.set);
    }

    public boolean isEntireSetOfXMLCharacters() {
        return !this.isRestrictedSet || this.set.size() > 255;
    }

    public Set<Integer> getCodePoints() {
        return this.set;
    }

    protected void handleToken(Token t, Set<Integer> s) {
        if (!this.isRestrictedSet || s.size() > 255) {
            return;
        }
        switch (t.type) {
            case 11: {
                this.isRestrictedSet = false;
                break;
            }
            case 0: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                Token.CharToken cht = (Token.CharToken)t;
                s.add(cht.getChar());
                break;
            }
            case 10: {
                Token.StringToken st = (Token.StringToken)t;
                String str = st.getString();
                int i = 0;
                while (i < str.length()) {
                    s.add(str.codePointAt(i));
                    ++i;
                }
                break;
            }
            case 4: {
                RangeToken rt = (RangeToken)t;
                int[] ranges = rt.ranges;
                int k = 0;
                while (k < ranges.length) {
                    if (ranges[k + 1] - ranges[k] > 255) {
                        this.isRestrictedSet = false;
                        return;
                    }
                    int codePoint = ranges[k];
                    while (codePoint <= ranges[k + 1]) {
                        s.add(codePoint);
                        ++codePoint;
                    }
                    k += 2;
                }
                break;
            }
            case 1: 
            case 2: {
                if (t instanceof Token.UnionToken) {
                    Token.UnionToken ut = (Token.UnionToken)t;
                    Vector children = ut.children;
                    int i = 0;
                    while (i < children.size()) {
                        Token subToken = (Token)children.get(i);
                        this.handleToken(subToken, s);
                        ++i;
                    }
                    break;
                }
                assert (t instanceof Token.ConcatToken);
                Token.ConcatToken cot = (Token.ConcatToken)t;
                this.handleToken(cot.child, s);
                break;
            }
            case 3: {
                Token.ClosureToken clt = (Token.ClosureToken)t;
                this.handleToken(clt.child, s);
                break;
            }
            case 6: {
                Token.ParenToken pt = (Token.ParenToken)t;
                this.handleToken(pt.child, s);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new RuntimeException("[EXI] RegExprToken " + t + " not handled!");
            }
        }
    }
}

