/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.core.RuntimeURIEntry;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.grammar.GrammarURIEntry;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaLessStartTag;
import com.siemens.ct.exi.helpers.DefaultErrorHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractEXICoder {
    protected final EXIFactory exiFactory;
    protected final Grammar grammar;
    protected final boolean isSchemaInformed;
    protected final FidelityOptions fidelityOptions;
    protected final boolean preservePrefix;
    protected ErrorHandler errorHandler;
    protected NamespaceSupport namespaces;
    protected ElementContext elementContext;
    protected Rule currentRule;
    private ElementContext[] elementContextStack;
    private int elementContextStackIndex;
    public static final int INITIAL_STACK_SIZE = 16;
    protected Map<QName, StartElement> runtimeElements;
    protected RuntimeURIEntry uriContext;
    protected List<RuntimeURIEntry> runtimeURIEntries;

    public AbstractEXICoder(EXIFactory exiFactory) {
        GrammarURIEntry[] grammarURIEntries;
        this.exiFactory = exiFactory;
        this.grammar = exiFactory.getGrammar();
        this.isSchemaInformed = this.grammar.isSchemaInformed();
        this.fidelityOptions = exiFactory.getFidelityOptions();
        this.preservePrefix = this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES");
        this.namespaces = new NamespaceSupport();
        this.errorHandler = new DefaultErrorHandler();
        this.runtimeElements = new HashMap<QName, StartElement>();
        this.elementContextStack = new ElementContext[16];
        this.runtimeURIEntries = new ArrayList<RuntimeURIEntry>();
        GrammarURIEntry[] grammarURIEntryArray = grammarURIEntries = this.grammar.getGrammarEntries();
        int n = grammarURIEntries.length;
        int n2 = 0;
        while (n2 < n) {
            GrammarURIEntry grammarEntry = grammarURIEntryArray[n2];
            this.addURI(grammarEntry.uri);
            String[] stringArray = grammarEntry.prefixes;
            int n3 = grammarEntry.prefixes.length;
            int n4 = 0;
            while (n4 < n3) {
                String prefix = stringArray[n4];
                this.uriContext.addPrefix(prefix);
                ++n4;
            }
            stringArray = grammarEntry.localNames;
            n3 = grammarEntry.localNames.length;
            n4 = 0;
            while (n4 < n3) {
                String localName = stringArray[n4];
                this.uriContext.addLocalName(localName);
                ++n4;
            }
            ++n2;
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    /*
     * Unable to fully structure code
     */
    protected void initForEachRun() throws EXIException, IOException {
        this.namespaces.reset();
        this.runtimeElements.clear();
        this.currentRule = this.exiFactory.isFragment() != false ? this.grammar.getBuiltInFragmentGrammar() : this.grammar.getBuiltInDocumentGrammar();
        this.elementContextStackIndex = 0;
        this.elementContextStack[this.elementContextStackIndex] = this.elementContext = new ElementContext(null, this.currentRule);
        grammarURIEntries = this.grammar.getGrammarEntries();
        if (AbstractEXICoder.$assertionsDisabled || grammarURIEntries.length <= this.runtimeURIEntries.size()) ** GOTO lbl11
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.runtimeURIEntries.remove(uriSize - 1);
lbl11:
            // 2 sources

            ** while (grammarURIEntries.length < (uriSize = this.runtimeURIEntries.size()))
        }
lbl12:
        // 1 sources

        i = 0;
        while (i < grammarURIEntries.length) {
            rue = this.runtimeURIEntries.get(i);
            grammarLocalNames = grammarURIEntries[i].localNames;
            while (grammarLocalNames.length < (localNameSize = rue.getLocalNameSize())) {
                rue.removeLocalName(localNameSize - 1);
            }
            grammarPrefixes = grammarURIEntries[i].prefixes;
            while (grammarPrefixes.length < (prefixSize = rue.getPrefixSize())) {
                rue.removePrefix(prefixSize - 1);
            }
            ++i;
        }
        this.uriContext = this.runtimeURIEntries.get(0);
    }

    protected final void pushElement(StartElement se, Rule contextRule) {
        this.elementContext.rule = contextRule;
        this.currentRule = se.getRule();
        this.pushElementContext(new ElementContext(se.getQName(), this.currentRule));
        this.namespaces.pushContext();
    }

    protected final void pushElementContext(ElementContext elementContext) {
        this.elementContext = elementContext;
        ++this.elementContextStackIndex;
        if (this.elementContextStack.length == this.elementContextStackIndex) {
            ElementContext[] elementContextStackNew = new ElementContext[this.elementContextStack.length << 2];
            System.arraycopy(this.elementContextStack, 0, elementContextStackNew, 0, this.elementContextStack.length);
            this.elementContextStack = elementContextStackNew;
        }
        this.elementContextStack[this.elementContextStackIndex] = elementContext;
    }

    protected final void popElement() {
        assert (this.elementContextStackIndex > 0);
        this.elementContextStack[this.elementContextStackIndex--] = null;
        this.elementContext = this.elementContextStack[this.elementContextStackIndex];
        this.currentRule = this.elementContext.rule;
        this.namespaces.popContext();
    }

    protected StartElement getGenericStartElement(QName qname) {
        StartElement nextSE = this.grammar.getGlobalElement(qname);
        if (nextSE == null && (nextSE = this.runtimeElements.get(qname)) == null) {
            nextSE = new StartElement(qname);
            nextSE.setRule(new SchemaLessStartTag());
            this.runtimeElements.put(qname, nextSE);
        }
        return nextSE;
    }

    protected QName getElementContextQName() {
        return this.elementContextStack[this.elementContextStackIndex].qname;
    }

    protected void updateURIContext(String namespaceURI) {
        if (this.uriContext.namespaceURI != namespaceURI) {
            for (RuntimeURIEntry uc : this.runtimeURIEntries) {
                if (!uc.namespaceURI.equals(namespaceURI)) continue;
                this.uriContext = uc;
                return;
            }
            this.uriContext = null;
        }
    }

    protected void addURI(String namespaceURI) {
        this.uriContext = new RuntimeURIEntry(namespaceURI, this.runtimeURIEntries.size());
        this.runtimeURIEntries.add(this.uriContext);
    }

    protected void throwWarning(String message) {
        this.errorHandler.warning(new EXIException(String.valueOf(message) + ", options=" + this.fidelityOptions));
    }

    static final class ElementContext {
        final QName qname;
        Rule rule;
        List<Object> prefixDeclarations;

        public ElementContext(QName qname, Rule rule) {
            this.qname = qname;
            this.rule = rule;
        }
    }
}

