/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.HugeIntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.math.BigInteger;
import javax.xml.namespace.QName;

public class NBitBigIntegerDatatype
extends AbstractDatatype {
    protected final BigInteger lowerBound;
    protected final HugeIntegerValue hiLowerBound;
    protected final BigInteger upperBound;
    protected final HugeIntegerValue hiUpperBound;
    protected final int numberOfBits4Range;
    private int valueToEncode;

    public NBitBigIntegerDatatype(QName datatypeIdentifier, BigInteger lowerBound, BigInteger upperBound, int boundedRange) {
        super(BuiltInType.NBIT_BIG_INTEGER, datatypeIdentifier);
        this.rcs = new XSDIntegerCharacterSet();
        this.lowerBound = lowerBound;
        this.hiLowerBound = NBitBigIntegerDatatype.getHugeInteger(lowerBound);
        this.upperBound = upperBound;
        this.hiUpperBound = NBitBigIntegerDatatype.getHugeInteger(upperBound);
        this.numberOfBits4Range = MethodsBag.getCodingLength(boundedRange);
    }

    protected static final HugeIntegerValue getHugeInteger(BigInteger bi) {
        if (bi.bitLength() <= 63) {
            return new HugeIntegerValue(bi.longValue());
        }
        return new HugeIntegerValue(bi);
    }

    public boolean isValid(String value) {
        try {
            BigInteger bValueToEncode = new BigInteger(value);
            if (bValueToEncode.compareTo(this.lowerBound) >= 0 && bValueToEncode.compareTo(this.upperBound) <= 0) {
                bValueToEncode = bValueToEncode.subtract(this.lowerBound);
                assert (bValueToEncode.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0);
                this.valueToEncode = bValueToEncode.intValue();
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.valueToEncode, this.numberOfBits4Range);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int decodedValue = valueChannel.decodeNBitUnsignedInteger(this.numberOfBits4Range);
        HugeIntegerValue hv = this.hiLowerBound.isLongValue ? new HugeIntegerValue((long)decodedValue + this.hiLowerBound.longValue) : new HugeIntegerValue(this.lowerBound.add(BigInteger.valueOf(decodedValue)));
        return hv;
    }
}

