/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class StringDecoderImpl
implements StringDecoder {
    List<Value> globalValues = new ArrayList<Value>();
    protected Map<QName, List<Value>> localValues = new HashMap<QName, List<Value>>();

    public Value readValue(QName context, DecoderChannel valueChannel) throws IOException {
        Value value;
        int i = valueChannel.decodeUnsignedInteger();
        switch (i) {
            case 0: {
                value = this.readValueLocalHit(context, valueChannel);
                break;
            }
            case 1: {
                value = this.readValueGlobalHit(context, valueChannel);
                break;
            }
            default: {
                value = new StringValue(valueChannel.decodeStringOnly(i - 2));
                this.addValue(context, value);
            }
        }
        assert (value != null);
        return value;
    }

    public Value readValueLocalHit(QName context, DecoderChannel valueChannel) throws IOException {
        List<Value> localChars = this.localValues.get(context);
        int n = MethodsBag.getCodingLength(localChars.size());
        int localID = valueChannel.decodeNBitUnsignedInteger(n);
        return localChars.get(localID);
    }

    public Value readValueGlobalHit(QName context, DecoderChannel valueChannel) throws IOException {
        int n = MethodsBag.getCodingLength(this.globalValues.size());
        int globalID = valueChannel.decodeNBitUnsignedInteger(n);
        return this.globalValues.get(globalID);
    }

    public void addValue(QName context, Value value) {
        assert (!this.globalValues.contains(value));
        this.globalValues.add(value);
        List<Value> lvs = this.localValues.get(context);
        if (lvs == null) {
            lvs = new ArrayList<Value>();
            this.localValues.put(context, lvs);
        }
        assert (!lvs.contains(value));
        lvs.add(value);
    }

    public void clear() {
        this.globalValues.clear();
        this.localValues.clear();
    }
}

