/*
 * Copyright, 2009 Koichi Takahashi. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.nec.exi.editor.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.nec.exi.editor.Activator;
import com.nec.exi.editor.Resources;
import com.siemens.ct.exi.CodingMode;

/**
 * @author Koichi Takahashi
 */
public class OptionSettingPage extends WizardPage {
	private Combo combo;
	private Button checkbox;

	public OptionSettingPage(ISelection selection) {
		super(Resources.get("OptionSettingPage.0"));  //$NON-NLS-1$
		setTitle(Resources.get("OptionSettingPage.1"));  //$NON-NLS-1$
		setDescription(Resources.get("OptionSettingPage.2"));  //$NON-NLS-1$
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 2;
		
		Label label = new Label(container, SWT.NULL);
		label.setText(Resources.get("OptionSettingPage.3"));  //$NON-NLS-1$

		combo = new Combo(container, SWT.NONE);
		String[][] _items = Activator.CODING_MODE_NV;
		String[] items = new String[_items.length-1];
		for(int i=0;i<items.length;i++){
			items[i] = _items[i+1][0];
		}
		combo.setItems(items);
		combo.setText(items[0]);
		
		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		checkbox = new Button(container, SWT.CHECK);
		checkbox.setText(Resources.get("OptionSettingPage.4"));  //$NON-NLS-1$
		checkbox.setLayoutData(gridData);
		
		setControl(container);
	}

	public CodingMode getCodingMode() {
		CodingMode codingMode = CodingMode.BIT_PACKED;
		String item = combo.getText();
		String[][] items = Activator.CODING_MODE_NV;
		for(int i=1;i<items.length;i++){
			if(item.equalsIgnoreCase(items[i][0])){
				codingMode = CodingMode.valueOf(items[i][1]);
				break;
			}
		}
		return codingMode;
	}
	
	public boolean isSchemaRef(){
		return checkbox.getSelection();
	}
	
}