/*
 * Copyright (C) 2007-2009 Siemens AG
 *
 * This program and its interfaces are free software;
 * you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package com.siemens.ct.exi.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

import com.siemens.ct.exi.core.CompileConfiguration;

/**
 * TODO Description
 * 
 * @author Daniel.Peintner.EXT@siemens.com
 * @author Joerg.Heuer@siemens.com
 * 
 * @version 0.3.20080718
 */

public class CompressionUtilities {
	public static DeflaterOutputStream createDeflaterOutputStream(
			OutputStream outputStream) {
		return new DeflaterOutputStream(outputStream, new Deflater(
				CompileConfiguration.COMPRESSION_LEVEL,
				CompileConfiguration.DEFLATE_NOWRAP));
	}

	public static InflaterInputStream createInflaterInputStream(
			InputStream inputStream) {
		return new InflaterInputStream(inputStream, new Inflater(
				CompileConfiguration.DEFLATE_NOWRAP));
	}
}
