/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SaxToDomHandler
extends DefaultHandler
implements LexicalHandler,
DTDHandler {
    protected Document document;
    protected Node currentNode;

    public SaxToDomHandler(Document doc) {
        this.document = doc;
        this.currentNode = this.document;
    }

    public SaxToDomHandler(Document doc, DocumentFragment docFragment) {
        this.document = doc;
        this.currentNode = docFragment;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        Element element = this.document.createElementNS(uri, qName);
        int i = 0;
        while (i < attrs.getLength()) {
            String ns_uri = attrs.getURI(i);
            String qname = attrs.getQName(i);
            String value = attrs.getValue(i);
            Attr attr = this.document.createAttributeNS(ns_uri, qname);
            attr.setValue(value);
            element.setAttributeNodeNS(attr);
            ++i;
        }
        this.currentNode.appendChild(element);
        this.currentNode = element;
    }

    public void endElement(String uri, String name, String qName) {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(char[] ch, int start, int length) {
        Text text = this.document.createTextNode(new String(ch, start, length));
        this.currentNode.appendChild(text);
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        this.currentNode.appendChild(pi);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        Comment cm = this.document.createComment(new String(ch, start, length));
        this.currentNode.appendChild(cm);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.currentNode instanceof Document) {
            DocumentType dt = this.document.getImplementation().createDocumentType(name, publicId, systemId);
            this.currentNode.appendChild(dt);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        System.out.println("notationDecl");
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        System.out.println("unparsedEntityDecl");
    }
}

