/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.Constants;
import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXICoder;
import com.siemens.ct.exi.core.RuntimeURIEntry;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.EventInformation;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.AttributeNS;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.TypeDecoder;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractEXIDecoder
extends AbstractEXICoder
implements EXIDecoder {
    protected Event nextEvent;
    protected Rule nextRule;
    protected EventType nextEventType;
    protected int ec;
    protected InputStream is;
    protected DecoderChannel channel;
    protected TypeDecoder typeDecoder;
    protected QName elementQName;
    protected String elementPrefix;
    protected QName attributeQName;
    protected String attributePrefix;
    protected Value attributeValue;
    protected QName xsiTypeQName;
    protected String xsiTypePrefix;
    protected boolean xsiNil;
    protected Value characters;
    protected String docTypeName;
    protected String docTypePublicID;
    protected String docTypeSystemID;
    protected String docTypeText;
    protected String entityReferenceName;
    protected char[] comment;
    protected String nsURI;
    protected String nsPrefix;
    protected String piTarget;
    protected String piData;
    protected Map<String, String> createdPrefixes = new HashMap<String, String>();
    protected int createdPfxCnt;
    static final Value XSD_BOOLEAN_TRUE_VALUE = new StringValue(Constants.XSD_BOOLEAN_TRUE_ARRAY);
    static final Value XSD_BOOLEAN_FALSE_VALUE = new StringValue(Constants.XSD_BOOLEAN_FALSE_ARRAY);

    public AbstractEXIDecoder(EXIFactory exiFactory) {
        super(exiFactory);
        this.typeDecoder = exiFactory.createTypeDecoder();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.createdPrefixes.clear();
        this.createdPfxCnt = 1;
        this.typeDecoder.clear();
    }

    protected String readUri() throws IOException {
        String uri;
        int nUri = MethodsBag.getCodingLength(this.runtimeURIEntries.size() + 1);
        int uriID = this.channel.decodeNBitUnsignedInteger(nUri);
        if (uriID == 0) {
            uri = new String(this.channel.decodeString());
            this.addURI(uri);
        } else {
            uri = ((RuntimeURIEntry)this.runtimeURIEntries.get((int)(uriID - 1))).namespaceURI;
            this.updateURIContext(uri);
        }
        return uri;
    }

    protected QName readLocalName(String uri) throws IOException {
        QName qname;
        this.updateURIContext(uri);
        int length = this.channel.decodeUnsignedInteger();
        if (length > 0) {
            String localName = new String(this.channel.decodeStringOnly(length - 1));
            qname = this.uriContext.addLocalName(localName);
        } else {
            int n = MethodsBag.getCodingLength(this.uriContext.getLocalNameSize());
            int localNameID = this.channel.decodeNBitUnsignedInteger(n);
            qname = this.uriContext.getNameContext(localNameID);
        }
        return qname;
    }

    protected String readPrefix(String uri) throws IOException {
        String prefix;
        int nPfx = MethodsBag.getCodingLength(this.uriContext.getPrefixSize() + 1);
        int pfxID = this.channel.decodeNBitUnsignedInteger(nPfx);
        if (pfxID == 0) {
            prefix = new String(this.channel.decodeString());
            this.uriContext.addPrefix(prefix);
        } else {
            prefix = this.uriContext.getPrefix(pfxID - 1);
        }
        return prefix;
    }

    protected void decodeEventCode() throws EXIException, IOException {
        int codeLength = this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions);
        int n = this.ec = codeLength > 0 ? this.channel.decodeNBitUnsignedInteger(codeLength) : 0;
        assert (this.ec >= 0);
        if (this.ec < this.currentRule.getNumberOfEvents()) {
            EventInformation ei = this.currentRule.lookFor(this.ec);
            this.nextEvent = ei.event;
            this.nextRule = ei.next;
            this.nextEventType = this.nextEvent.getEventType();
        } else {
            int ec2 = this.decode2ndLevelEventCode();
            if (ec2 == -1) {
                int ec3 = this.decode3rdLevelEventCode();
                this.nextEventType = this.currentRule.get3rdLevelEvent(ec3, this.fidelityOptions);
                this.nextEvent = null;
                this.nextRule = null;
            } else {
                this.nextEventType = this.currentRule.get2ndLevelEvent(ec2, this.fidelityOptions);
                if (this.nextEventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    this.updateInvalidValueAttribute();
                } else {
                    this.nextEvent = null;
                    this.nextRule = null;
                }
            }
        }
    }

    protected void updateInvalidValueAttribute() throws EXIException {
        int ec3AT;
        SchemaInformedRule sir = (SchemaInformedRule)this.currentRule;
        try {
            ec3AT = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(sir.getNumberOfSchemaDeviatedAttributes()));
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
        if (ec3AT < sir.getNumberOfSchemaDeviatedAttributes() - 1) {
            this.ec = ec3AT + sir.getLeastAttributeEventCode();
            EventInformation ei = this.currentRule.lookFor(this.ec);
            this.nextEvent = ei.event;
            this.nextRule = ei.next;
        } else if (ec3AT == sir.getNumberOfSchemaDeviatedAttributes() - 1) {
            this.nextEventType = EventType.ATTRIBUTE_ANY_INVALID_VALUE;
        } else {
            throw new EXIException("Error occured while decoding deviated attribute");
        }
    }

    protected int decode2ndLevelEventCode() throws EXIException, IOException {
        int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
        int level2 = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch2));
        if (this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions) > 0) {
            return level2 < ch2 - 1 ? level2 : -1;
        }
        return level2 < ch2 ? level2 : -1;
    }

    protected int decode3rdLevelEventCode() throws EXIException, IOException {
        int ch3 = this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions);
        return this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch3));
    }

    protected String decodeQNamePrefix(QName qname) throws EXIException, IOException {
        if (this.preservePrefix) {
            String prefix = null;
            String uri = qname.getNamespaceURI();
            if (uri.equals("")) {
                prefix = "";
            } else {
                this.updateURIContext(uri);
                List<String> prefixes = this.uriContext.prefixes;
                int numberOfPrefixes = prefixes.size();
                if (numberOfPrefixes > 0) {
                    int id = 0;
                    if (numberOfPrefixes > 1) {
                        id = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(numberOfPrefixes));
                    }
                    prefix = prefixes.get(id);
                }
            }
            return prefix;
        }
        return null;
    }

    protected void decodeStartElementExpandedName() throws EXIException, IOException {
        this.elementQName = this.readLocalName(this.readUri());
    }

    protected void decodeAttributeXsiNilStructure() throws EXIException, IOException {
        this.xsiNil = this.channel.decodeBoolean();
        if (this.xsiNil && this.currentRule.isSchemaInformed()) {
            this.currentRule = ((SchemaInformedRule)this.currentRule).getTypeEmpty();
        }
        this.attributeValue = this.xsiNil ? XSD_BOOLEAN_TRUE_VALUE : XSD_BOOLEAN_FALSE_VALUE;
    }

    protected void decodeAttributeXsiTypeStructure() throws EXIException, IOException {
        this.xsiTypeQName = this.readLocalName(this.readUri());
        this.xsiTypePrefix = this.decodeQNamePrefix(this.xsiTypeQName);
        TypeGrammar tg = this.grammar.getTypeGrammar(this.xsiTypeQName);
        if (tg != null) {
            this.currentRule = tg.getType();
        }
        this.attributeValue = new StringValue(this.getQualifiedName(this.xsiTypeQName, this.xsiTypePrefix));
        this.attributePrefix = null;
    }

    protected Datatype decodeAttributeStructure() throws EXIException, IOException {
        Attribute at = (Attribute)this.nextEvent;
        this.attributeQName = at.getQName();
        this.attributePrefix = this.decodeQNamePrefix(this.attributeQName);
        this.currentRule = this.nextRule;
        return at.getDatatype();
    }

    protected Datatype decodeAttributeNSStructure() throws EXIException, IOException {
        AttributeNS atNS = (AttributeNS)this.nextEvent;
        this.attributeQName = this.readLocalName(atNS.getNamespaceURI());
        this.attributePrefix = this.decodeQNamePrefix(this.attributeQName);
        this.currentRule = this.nextRule;
        return BuiltIn.DEFAULT_DATATYPE;
    }

    protected Datatype decodeAttributeInvalidValueStructure() throws EXIException, IOException {
        Attribute at = (Attribute)this.nextEvent;
        this.attributeQName = at.getQName();
        this.attributePrefix = this.decodeQNamePrefix(this.attributeQName);
        this.currentRule = this.nextRule;
        return BuiltIn.DEFAULT_DATATYPE;
    }

    protected Datatype decodeAttributeAnyInvalidValueStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        return BuiltIn.DEFAULT_DATATYPE;
    }

    protected Datatype decodeAttributeGenericStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.currentRule = this.nextRule;
        Attribute globalAT = this.grammar.getGlobalAttribute(this.attributeQName);
        return globalAT == null ? BuiltIn.DEFAULT_DATATYPE : globalAT.getDatatype();
    }

    protected Datatype decodeAttributeGenericUndeclaredStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.currentRule.learnAttribute(new Attribute(this.attributeQName));
        return BuiltIn.DEFAULT_DATATYPE;
    }

    private void decodeAttributeGenericStructureOnly() throws EXIException, IOException {
        this.attributeQName = this.readLocalName(this.readUri());
        this.attributePrefix = this.decodeQNamePrefix(this.attributeQName);
    }

    protected Datatype decodeCharactersStructureOnly() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS);
        this.currentRule = this.nextRule;
        return ((Characters)this.nextEvent).getDatatype();
    }

    protected Datatype decodeCharactersGenericStructureOnly() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC);
        this.currentRule = this.nextRule;
        return BuiltIn.DEFAULT_DATATYPE;
    }

    protected Datatype decodeCharactersGenericUndeclaredStructureOnly() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC_UNDECLARED);
        this.currentRule.learnCharacters();
        this.currentRule = this.currentRule.getElementContentRule();
        return BuiltIn.DEFAULT_DATATYPE;
    }

    protected String getQualifiedName(QName qname, String pfx) {
        String sqname;
        String localName = qname.getLocalPart();
        if (pfx == null) {
            String uri = qname.getNamespaceURI();
            if (uri.equals("") || uri.equals(this.namespaces.getURI(""))) {
                pfx = "";
                sqname = localName;
            } else {
                pfx = this.namespaces.getPrefix(uri);
                if (pfx == null) {
                    pfx = this.getUniquePrefix(uri);
                    sqname = String.valueOf(pfx) + ":" + localName;
                } else {
                    sqname = pfx.length() == 0 ? localName : String.valueOf(pfx) + ":" + localName;
                }
            }
        } else {
            sqname = pfx.length() == 0 ? localName : String.valueOf(pfx) + ":" + localName;
        }
        return sqname;
    }

    protected String getUniquePrefix(String uri) {
        String pfx = this.createdPrefixes.get(uri);
        if (pfx != null) {
            if (this.namespaces.getPrefix(uri) == null) {
                this.namespaces.declarePrefix(pfx, uri);
            }
        } else {
            while (this.namespaces.getURI(pfx = "ns" + this.createdPfxCnt++) != null) {
            }
            this.namespaces.declarePrefix(pfx, uri);
            this.createdPrefixes.put(uri, pfx);
        }
        return pfx;
    }

    public String getElementURI() {
        return this.elementQName.getNamespaceURI();
    }

    public String getElementLocalName() {
        return this.elementQName.getLocalPart();
    }

    public String getElementQName() {
        return this.getQualifiedName(this.elementQName, this.elementPrefix);
    }

    public String getAttributeURI() {
        return this.attributeQName.getNamespaceURI();
    }

    public String getAttributeLocalName() {
        return this.attributeQName.getLocalPart();
    }

    public String getAttributeQName() {
        return this.getQualifiedName(this.attributeQName, this.attributePrefix);
    }

    public String getAttributeValue() {
        return this.attributeValue.toString();
    }

    public char[] getCharacters() {
        return this.characters.toCharacters();
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public String getDocTypePublicID() {
        return this.docTypePublicID;
    }

    public String getDocTypeSystemID() {
        return this.docTypeSystemID;
    }

    public String getDocTypeText() {
        return this.docTypeText;
    }

    public String getEntityReferenceName() {
        return this.entityReferenceName;
    }

    public char[] getComment() {
        return this.comment;
    }

    public String getPITarget() {
        return this.piTarget;
    }

    public String getPIData() {
        return this.piData;
    }

    public void decodeStartFragmentSelfContained() throws EXIException, IOException {
        throw new RuntimeException("[EXI] SelfContained");
    }
}

