/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXIEncoder;
import com.siemens.ct.exi.core.container.ContextContainer;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.ByteEncoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.xml.namespace.QName;

public class EXIEncoderReordered
extends AbstractEXIEncoder {
    protected DeflaterOutputStream deflater;
    protected CodingMode codingMode;
    protected int blockValues;
    protected String lastValue;
    protected Datatype lastDatatype;
    protected List<QName> contextOrders = new ArrayList<QName>();
    protected Map<QName, ContextContainer> contexts = new HashMap<QName, ContextContainer>();

    public EXIEncoderReordered(EXIFactory exiFactory) {
        super(exiFactory);
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.blockValues = 0;
        this.contextOrders.clear();
        this.contexts.clear();
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        super.setOutput(os, exiBodyOnly);
        this.codingMode = this.exiFactory.getCodingMode();
        this.channel = new ByteEncoderChannel(this.getStream());
    }

    protected boolean isTypeValid(Datatype datatype, String value) {
        this.lastDatatype = datatype;
        this.lastValue = value;
        return super.isTypeValid(datatype, value);
    }

    protected void updateContextValue(QName valueContext, String value, Datatype datatype) {
        ContextContainer cc = this.contexts.get(valueContext);
        if (cc == null) {
            cc = new ContextContainer();
            this.contexts.put(valueContext, cc);
            this.contextOrders.add(valueContext);
        }
        cc.addValue(value, datatype);
        ++this.blockValues;
    }

    protected void writeValueTypeValid(QName valueContext) throws IOException {
        this.updateContextValue(valueContext, this.lastValue, this.lastDatatype);
    }

    public void writeValueAsString(QName valueContext, String value) throws IOException {
        this.updateContextValue(valueContext, value, BuiltIn.DEFAULT_DATATYPE);
    }

    protected OutputStream getStream() {
        if (this.codingMode == CodingMode.COMPRESSION) {
            this.deflater = new DeflaterOutputStream(this.os, new Deflater(this.codingMode.getDeflateLevel(), true));
            return this.deflater;
        }
        assert (this.codingMode == CodingMode.PRE_COMPRESSION);
        return this.os;
    }

    protected void finalizeStream() throws IOException {
        if (this.codingMode == CodingMode.COMPRESSION) {
            this.deflater.finish();
        }
    }

    public void flush() throws IOException {
        if (this.blockValues <= 100) {
            for (QName contextOrder : this.contextOrders) {
                ContextContainer cc = this.contexts.get(contextOrder);
                List<String> values = cc.getValues();
                List<Datatype> valueDatatypes = cc.getValueDatatypes();
                int i = 0;
                while (i < values.size()) {
                    this.typeEncoder.isValid(valueDatatypes.get(i), values.get(i));
                    this.typeEncoder.writeValue(contextOrder, this.channel);
                    ++i;
                }
            }
            this.finalizeStream();
        } else {
            List<Datatype> valueDatatypes;
            List<String> values;
            ContextContainer cc;
            this.finalizeStream();
            ByteEncoderChannel leq100 = new ByteEncoderChannel(this.getStream());
            boolean wasThereLeq100 = false;
            for (QName contextOrder : this.contextOrders) {
                cc = this.contexts.get(contextOrder);
                values = cc.getValues();
                if (values.size() > 100) continue;
                valueDatatypes = cc.getValueDatatypes();
                int i = 0;
                while (i < values.size()) {
                    this.typeEncoder.isValid(valueDatatypes.get(i), values.get(i));
                    this.typeEncoder.writeValue(contextOrder, leq100);
                    ++i;
                }
                wasThereLeq100 = true;
            }
            if (wasThereLeq100) {
                this.finalizeStream();
            }
            for (QName contextOrder : this.contextOrders) {
                cc = this.contexts.get(contextOrder);
                values = cc.getValues();
                if (values.size() <= 100) continue;
                valueDatatypes = cc.getValueDatatypes();
                ByteEncoderChannel gre100 = new ByteEncoderChannel(this.getStream());
                int i = 0;
                while (i < values.size()) {
                    this.typeEncoder.isValid(valueDatatypes.get(i), values.get(i));
                    this.typeEncoder.writeValue(contextOrder, gre100);
                    ++i;
                }
                this.finalizeStream();
            }
        }
        this.os.flush();
    }
}

