/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class RuntimeURIEntry {
    public final String namespaceURI;
    public final int id;
    protected final List<QName> localNames;
    protected final Map<String, Integer> localNameIDs;
    protected final List<String> prefixes;
    protected final Map<String, Integer> prefixIDs;

    public RuntimeURIEntry(String namespaceURI, int id) {
        this.namespaceURI = namespaceURI;
        this.id = id;
        this.localNames = new ArrayList<QName>();
        this.localNameIDs = new HashMap<String, Integer>();
        this.prefixes = new ArrayList<String>();
        this.prefixIDs = new HashMap<String, Integer>();
    }

    public Integer getLocalNameID(String localName) {
        return this.localNameIDs.get(localName);
    }

    public QName getNameContext(int localNameID) {
        return this.localNames.get(localNameID);
    }

    public QName addLocalName(String localName) {
        this.localNameIDs.put(localName, this.localNames.size());
        QName qname = new QName(this.namespaceURI, localName);
        this.localNames.add(qname);
        return qname;
    }

    public QName removeLocalName(int localNameID) {
        QName qname = this.localNames.remove(localNameID);
        this.localNameIDs.remove(qname.getLocalPart());
        return qname;
    }

    public int getLocalNameSize() {
        return this.localNames.size();
    }

    public void addPrefix(String prefix) {
        assert (!this.prefixes.contains(prefix));
        int prefixID = this.prefixes.size();
        this.prefixIDs.put(prefix, prefixID);
        this.prefixes.add(prefix);
    }

    public String removePrefix(int prefixID) {
        String pfx = this.prefixes.remove(prefixID);
        this.prefixIDs.remove(pfx);
        return pfx;
    }

    public Integer getPrefixID(String prefix) {
        return this.prefixIDs.get(prefix);
    }

    public String getPrefix(int prefixID) {
        return this.prefixes.get(prefixID);
    }

    public int getPrefixSize() {
        return this.prefixes.size();
    }

    public String toString() {
        return String.valueOf(this.namespaceURI) + "(" + this.id + ")";
    }
}

