/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.sax;

import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.EventType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXDecoder
implements XMLReader {
    protected EXIFactory exiFactory;
    protected EXIDecoder decoder;
    protected ContentHandler contentHandler;
    protected DTDHandler dtdHandler;
    protected ErrorHandler errorHandler;
    protected static final String ATTRIBUTE_TYPE = "CDATA";
    protected AttributesImpl attributes = new AttributesImpl();
    protected String deferredStartElementUri;
    protected String deferredStartElementLocalName;
    protected List<String> eeQualifiedNames;

    public SAXDecoder(EXIFactory exiFactory) {
        this.exiFactory = exiFactory;
        this.decoder = exiFactory.createEXIDecoder();
        this.eeQualifiedNames = new ArrayList<String>();
    }

    protected void initForEachRun() {
        this.deferredStartElementUri = null;
        this.deferredStartElementLocalName = null;
        this.eeQualifiedNames.clear();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void parse(String systemId) throws IOException, SAXException {
        FileInputStream fis = new FileInputStream(systemId);
        InputSource is = new InputSource(fis);
        this.parse(is);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        assert (inputSource != null);
        assert (this.decoder != null);
        try {
            InputStream inputStream = inputSource.getByteStream();
            this.decoder.setInputStream(inputStream, this.exiFactory.isEXIBodyOnly());
            if (this.contentHandler == null) {
                throw new SAXException("No content handler set!");
            }
            this.initForEachRun();
            boolean hasNext = this.decoder.hasNext();
            assert (hasNext);
            EventType eventType = this.decoder.next();
            assert (eventType == EventType.START_DOCUMENT);
            this.decoder.decodeStartDocument();
            this.contentHandler.startDocument();
            NamespaceSupport namespaces = this.decoder.getNamespaces();
            Enumeration<String> declaredPrefixes = namespaces.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String pfx = declaredPrefixes.nextElement();
                String uri = namespaces.getURI(pfx);
                if (uri == null) {
                    uri = "";
                }
                this.contentHandler.startPrefixMapping(pfx, uri);
            }
            while (this.decoder.hasNext()) {
                eventType = this.decoder.next();
                this.parseElementContent(eventType);
            }
            this.decoder.decodeEndDocument();
            this.contentHandler.endDocument();
        }
        catch (EXIException e) {
            throw new SAXException("EXI", e);
        }
    }

    protected void parseStartTagContent() throws IOException, EXIException, SAXException {
        this.decoder.hasNext();
        EventType eventType = this.decoder.next();
        switch (eventType) {
            case ATTRIBUTE: {
                this.decoder.decodeAttribute();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_NS: {
                this.decoder.decodeAttributeNS();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_XSI_NIL: {
                this.decoder.decodeAttributeXsiNil();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_XSI_TYPE: {
                this.decoder.decodeAttributeXsiType();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_INVALID_VALUE: {
                this.decoder.decodeAttributeInvalidValue();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_ANY_INVALID_VALUE: {
                this.decoder.decodeAttributeAnyInvalidValue();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_GENERIC: {
                this.decoder.decodeAttributeGeneric();
                this.handleAttribute();
                break;
            }
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                this.decoder.decodeAttributeGenericUndeclared();
                this.handleAttribute();
                break;
            }
            case NAMESPACE_DECLARATION: {
                this.decoder.decodeNamespaceDeclaration();
                this.parseStartTagContent();
                break;
            }
            case SELF_CONTAINED: {
                this.decoder.decodeStartFragmentSelfContained();
                this.parseStartTagContent();
                break;
            }
            default: {
                String qname = this.decoder.getElementQName();
                NamespaceSupport namespaces = this.decoder.getNamespaces();
                Enumeration<String> declaredPrefixes = namespaces.getDeclaredPrefixes();
                while (declaredPrefixes.hasMoreElements()) {
                    String pfx = declaredPrefixes.nextElement();
                    String uri = namespaces.getURI(pfx);
                    if (uri == null) {
                        uri = "";
                    }
                    this.contentHandler.startPrefixMapping(pfx, uri);
                }
                this.contentHandler.startElement(this.deferredStartElementUri, this.deferredStartElementLocalName, qname, this.attributes);
                this.eeQualifiedNames.add(qname);
                this.attributes.clear();
                this.parseElementContent(eventType);
            }
        }
    }

    protected void parseElementContent(EventType eventType) throws IOException, EXIException, SAXException {
        switch (eventType) {
            case START_ELEMENT: {
                this.decoder.decodeStartElement();
                this.handleStartElement();
                break;
            }
            case START_ELEMENT_NS: {
                this.decoder.decodeStartElementNS();
                this.handleStartElement();
                break;
            }
            case START_ELEMENT_GENERIC: {
                this.decoder.decodeStartElementGeneric();
                this.handleStartElement();
                break;
            }
            case START_ELEMENT_GENERIC_UNDECLARED: {
                this.decoder.decodeStartElementGenericUndeclared();
                this.handleStartElement();
                break;
            }
            case END_ELEMENT: {
                this.decoder.decodeEndElement();
                this.handleEndElement();
                break;
            }
            case END_ELEMENT_UNDECLARED: {
                this.decoder.decodeEndElementUndeclared();
                this.handleEndElement();
                break;
            }
            case CHARACTERS: {
                this.decoder.decodeCharacters();
                this.handleCharacters();
                break;
            }
            case CHARACTERS_GENERIC: {
                this.decoder.decodeCharactersGeneric();
                this.handleCharacters();
                break;
            }
            case CHARACTERS_GENERIC_UNDECLARED: {
                this.decoder.decodeCharactersGenericUndeclared();
                this.handleCharacters();
                break;
            }
            case DOC_TYPE: {
                this.decoder.decodeDocType();
                this.handleDocType();
                break;
            }
            case ENTITY_REFERENCE: {
                this.decoder.decodeEntityReference();
                this.handleEntityReference();
                break;
            }
            case COMMENT: {
                this.decoder.decodeComment();
                this.handleComment();
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.decoder.decodeProcessingInstruction();
                this.contentHandler.processingInstruction(this.decoder.getPITarget(), this.decoder.getPIData());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)eventType) + "' ");
            }
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    protected void handleStartElement() throws SAXException, IOException, EXIException {
        this.deferredStartElementUri = this.decoder.getElementURI();
        this.deferredStartElementLocalName = this.decoder.getElementLocalName();
        this.parseStartTagContent();
    }

    protected void handleEndElement() throws SAXException, IOException {
        this.contentHandler.endElement(this.decoder.getElementURI(), this.decoder.getElementLocalName(), this.eeQualifiedNames.remove(this.eeQualifiedNames.size() - 1));
    }

    protected void handleAttribute() throws SAXException, IOException, EXIException {
        this.attributes.addAttribute(this.decoder.getAttributeURI(), this.decoder.getAttributeLocalName(), this.decoder.getAttributeQName(), ATTRIBUTE_TYPE, this.decoder.getAttributeValue());
        this.parseStartTagContent();
    }

    protected void handleCharacters() throws SAXException, IOException {
        char[] chars = this.decoder.getCharacters();
        this.contentHandler.characters(chars, 0, chars.length);
    }

    protected void handleDocType() throws SAXException, IOException {
    }

    protected void handleEntityReference() throws SAXException {
    }

    protected void handleComment() throws SAXException {
    }
}

