/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.sax;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.sax.SAXDecoder;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDecoderExtendedHandler
extends SAXDecoder
implements DeclHandler {
    protected Map<String, String> entities = new HashMap<String, String>();
    protected boolean dummyEntityWritten;
    protected static final boolean disable_ouput_escaping = true;

    public SAXDecoderExtendedHandler(EXIFactory exiFactory) {
        super(exiFactory);
    }

    protected void initForEachRun() {
        super.initForEachRun();
        this.entities.clear();
        this.dummyEntityWritten = false;
    }

    protected void handleDocType() throws SAXException, IOException {
        if (this.contentHandler instanceof LexicalHandler) {
            LexicalHandler lh = (LexicalHandler)((Object)this.contentHandler);
            String publicID = this.decoder.getDocTypePublicID().length() == 0 ? null : this.decoder.getDocTypePublicID();
            String systemID = this.decoder.getDocTypeSystemID().length() == 0 ? null : this.decoder.getDocTypeSystemID();
            lh.startDTD(this.decoder.getDocTypeName(), publicID, systemID);
            String docTypeText = this.decoder.getDocTypeText();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            StringReader r = new StringReader("<!DOCTYPE foo [" + docTypeText + " ]>" + "<foo/>");
            xmlReader.parse(new InputSource(r));
            lh.endDTD();
        }
    }

    protected void handleEntityReference() throws SAXException {
        if (this.contentHandler instanceof LexicalHandler) {
            String entityReferenceName = this.decoder.getEntityReferenceName();
            char[] entity = ("&" + entityReferenceName + ";").toCharArray();
            this.contentHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
            this.contentHandler.characters(entity, 0, entity.length);
            this.contentHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
        }
    }

    protected void handleComment() throws SAXException {
        if (this.contentHandler instanceof LexicalHandler) {
            LexicalHandler lh = (LexicalHandler)((Object)this.contentHandler);
            char[] comment = this.decoder.getComment();
            lh.comment(comment, 0, comment.length);
        }
    }

    public void attributeDecl(String name, String name2, String type, String mode, String value) throws SAXException {
        if (this.contentHandler instanceof DeclHandler) {
            this.checkDummyEntity();
            DeclHandler dh = (DeclHandler)((Object)this.contentHandler);
            dh.attributeDecl(name, name2, type, mode, value);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.contentHandler instanceof DeclHandler) {
            this.checkDummyEntity();
            DeclHandler dh = (DeclHandler)((Object)this.contentHandler);
            dh.elementDecl(name, model);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.contentHandler instanceof DeclHandler) {
            DeclHandler dh = (DeclHandler)((Object)this.contentHandler);
            dh.externalEntityDecl(name, publicId, systemId);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.contentHandler instanceof DeclHandler) {
            DeclHandler dh = (DeclHandler)((Object)this.contentHandler);
            dh.internalEntityDecl(name, value);
        }
    }

    protected void checkDummyEntity() throws SAXException {
        if (!this.dummyEntityWritten) {
            this.internalEntityDecl("dummyEntity", "dummyValue");
            this.dummyEntityWritten = true;
        }
    }
}

