/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.XSDBase64;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public abstract class AbstractBinaryDatatype
extends AbstractDatatype {
    protected XSDBase64 xsdBase64 = XSDBase64.newInstance();

    public AbstractBinaryDatatype(QName datatypeIdentifier, BuiltInType binaryType) {
        super(binaryType, datatypeIdentifier);
        assert (binaryType == BuiltInType.BINARY_BASE64 || binaryType == BuiltInType.BINARY_HEX);
    }

    public boolean isValid(String value) {
        return this.xsdBase64.parse(value.toCharArray(), 0, value.length());
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeBinary(this.xsdBase64.getBytes());
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeBinary();
    }
}

