/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public abstract class AbstractDatatype
implements Datatype {
    protected BuiltInType defaultbuiltInType;
    protected QName datatypeIdentifier;
    protected RestrictedCharacterSet rcs;
    protected String lastRCSValue;

    public AbstractDatatype(BuiltInType builtInType, QName datatypeIdentifier) {
        this.defaultbuiltInType = builtInType;
        this.datatypeIdentifier = datatypeIdentifier;
    }

    public BuiltInType getDefaultBuiltInType() {
        return this.defaultbuiltInType;
    }

    public QName getDatatypeIdentifier() {
        return this.datatypeIdentifier;
    }

    public RestrictedCharacterSet getRestrictedCharacterSet() {
        return this.rcs;
    }

    public boolean equals(Object o) {
        if (o instanceof Datatype) {
            return this.defaultbuiltInType == ((Datatype)o).getDefaultBuiltInType();
        }
        return false;
    }

    public int hashCode() {
        return this.defaultbuiltInType.ordinal();
    }

    public boolean isValidRCS(String value) {
        this.lastRCSValue = value;
        return true;
    }

    public void writeValueRCS(RestrictedCharacterSetDatatype rcsEncoder, EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        rcsEncoder.setRestrictedCharacterSet(this.rcs);
        rcsEncoder.isValid(this.lastRCSValue);
        rcsEncoder.writeValue(valueChannel, stringEncoder, context);
    }

    public Value readValueRCS(RestrictedCharacterSetDatatype rcsDecoder, DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        rcsDecoder.setRestrictedCharacterSet(this.rcs);
        return rcsDecoder.readValue(valueChannel, stringDecoder, context);
    }

    public String toString() {
        return this.defaultbuiltInType.toString();
    }
}

