/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.util.datatype.XSDDatetime;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class DatetimeDatatype
extends AbstractDatatype {
    DatetimeType datetimeType;
    private XSDDatetime lastValidDatetime = XSDDatetime.newInstance();

    public DatetimeDatatype(DatetimeType dateType, QName datatypeIdentifier) {
        super(BuiltInType.DATETIME, datatypeIdentifier);
        this.rcs = new XSDDateTimeCharacterSet();
        this.datetimeType = dateType;
    }

    public DatetimeType getDatetimeType() {
        return this.datetimeType;
    }

    public boolean isValid(String value) {
        return this.lastValidDatetime.parse(value, this.datetimeType);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeDateTime(this.lastValidDatetime);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeDateTimeValue(this.datetimeType);
    }
}

