/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.XSDFloat;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class FloatDatatype
extends AbstractDatatype {
    protected XSDFloat lastValidFloat = XSDFloat.newInstance();

    public FloatDatatype(QName datatypeIdentifier) {
        super(BuiltInType.FLOAT, datatypeIdentifier);
        this.rcs = new XSDDoubleCharacterSet();
    }

    public boolean isValid(String value) {
        return this.lastValidFloat.parse(value);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeFloat(this.lastValidFloat.mantissa, this.lastValidFloat.exponent);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeFloatValue();
    }
}

