/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    public static final int BITS_IN_BYTE = 8;
    protected int buffer = 0;
    protected int capacity = 8;
    private OutputStream ostream;

    public BitOutputStream(OutputStream ostream) {
        this.ostream = ostream;
    }

    public OutputStream getUnderlyingOutputStream() {
        return this.ostream;
    }

    protected void flushBuffer() throws IOException {
        if (this.capacity == 0) {
            this.ostream.write(this.buffer);
            this.capacity = 8;
            this.buffer = 0;
        }
    }

    public boolean isByteAligned() {
        return this.capacity == 8;
    }

    public int getBitsInBuffer() {
        return 8 - this.capacity;
    }

    public void flush() throws IOException {
        this.align();
    }

    public void align() throws IOException {
        if (this.capacity < 8) {
            this.ostream.write(this.buffer << this.capacity);
            this.capacity = 8;
            this.buffer = 0;
        }
    }

    public void writeBit0() throws IOException {
        this.buffer <<= 1;
        --this.capacity;
        this.flushBuffer();
    }

    public void writeBit1() throws IOException {
        this.buffer = this.buffer << 1 | 1;
        --this.capacity;
        this.flushBuffer();
    }

    protected void writeBit(int b) throws IOException {
        this.buffer = this.buffer << 1 | b & 1;
        --this.capacity;
        this.flushBuffer();
    }

    public void writeBits(int b, int n) throws IOException {
        if (n <= this.capacity) {
            this.buffer = this.buffer << n | b & 255 >> 8 - n;
            this.capacity -= n;
            if (this.capacity == 0) {
                this.ostream.write(this.buffer);
                this.capacity = 8;
            }
        } else {
            this.buffer = this.buffer << this.capacity | b >>> n - this.capacity & 255 >> 8 - this.capacity;
            n -= this.capacity;
            this.ostream.write(this.buffer);
            while (n >= 8) {
                this.ostream.write(b >>> (n -= 8));
            }
            this.buffer = b;
            this.capacity = 8 - n;
        }
    }

    protected void writeDirectByte(int b) throws IOException {
        this.ostream.write(b);
    }

    protected void writeDirectBytes(byte[] b, int off, int len) throws IOException {
        this.ostream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.writeBits(b, 8);
    }
}

