/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util;

import java.math.BigInteger;

public class MethodsBag {
    static final int[] smallLengths;
    static final char[] INTEGER_MIN_VALUE_CHARARRAY;
    static final char[] LONG_MIN_VALUE_CHARARRAY;
    static final char[] DigitOnes;
    static final char[] DigitTens;
    static final char[] digits;
    static final int[] sizeTable;

    static {
        int[] nArray = new int[17];
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 3;
        nArray[7] = 3;
        nArray[8] = 3;
        nArray[9] = 4;
        nArray[10] = 4;
        nArray[11] = 4;
        nArray[12] = 4;
        nArray[13] = 4;
        nArray[14] = 4;
        nArray[15] = 4;
        nArray[16] = 4;
        smallLengths = nArray;
        INTEGER_MIN_VALUE_CHARARRAY = "-2147483648".toCharArray();
        LONG_MIN_VALUE_CHARARRAY = "-9223372036854775808".toCharArray();
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    }

    public static int numberOf7BitBlocksToRepresent(int n) {
        assert (n >= 0);
        if (n < 128) {
            return 1;
        }
        if (n < 16384) {
            return 2;
        }
        if (n < 0x200000) {
            return 3;
        }
        if (n < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int numberOf7BitBlocksToRepresent(long l) {
        if (l < -1L) {
            return MethodsBag.numberOf7BitBlocksToRepresent((int)l);
        }
        if (l < 0x800000000L) {
            return 5;
        }
        if (l < 0x40000000000L) {
            return 6;
        }
        if (l < 0x2000000000000L) {
            return 7;
        }
        if (l < 0x100000000000000L) {
            return 8;
        }
        if (l < Long.MIN_VALUE) {
            return 9;
        }
        return 10;
    }

    public static final int getCodingLength(int characteristics) {
        if (characteristics < 17) {
            return smallLengths[characteristics];
        }
        if (characteristics < 33) {
            return 5;
        }
        if (characteristics < 65) {
            return 6;
        }
        if (characteristics < 129) {
            return 7;
        }
        return (int)Math.ceil(Math.log(characteristics) / Math.log(2.0));
    }

    static final int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static final int stringSize(long x) {
        long p = 10L;
        int i = 1;
        while (i < 19) {
            if (x < p) {
                return i;
            }
            p *= 10L;
            ++i;
        }
        return 19;
    }

    public static final int getStringSize(int i) {
        return i < 0 ? MethodsBag.stringSize(-i) + 1 : MethodsBag.stringSize(i);
    }

    public static final int getStringSize(long l) {
        return l < 0L ? MethodsBag.stringSize(-l) + 1 : MethodsBag.stringSize(l);
    }

    static final void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--index] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--index] = sign;
        }
    }

    static final int getCharsReverse(int i, int index, char[] buf) {
        int r;
        int q;
        assert (i >= 0);
        int posChar = index;
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[posChar++] = DigitOnes[r];
            buf[posChar++] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[posChar++] = digits[r];
        } while ((i = q) != 0);
        return posChar - index;
    }

    static final void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--index] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--index] = sign;
        }
    }

    /*
     * Unable to fully structure code
     */
    static final void getCharsReverse(long i, int index, char[] buf) {
        if (MethodsBag.$assertionsDisabled || i >= 0L) ** GOTO lbl8
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[index++] = MethodsBag.DigitOnes[r];
            buf[index++] = MethodsBag.DigitTens[r];
lbl8:
            // 2 sources

            ** while (i > 0x7FFFFFFFL)
        }
lbl9:
        // 1 sources

        i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[index++] = MethodsBag.DigitOnes[r];
            buf[index++] = MethodsBag.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[index++] = MethodsBag.digits[r];
        } while ((i2 = q2) != 0);
    }

    public static char[] itos(int i) {
        if (i == Integer.MIN_VALUE) {
            return INTEGER_MIN_VALUE_CHARARRAY;
        }
        int size = MethodsBag.getStringSize(i);
        char[] buf = new char[size];
        MethodsBag.getChars(i, size, buf);
        return buf;
    }

    public static void itos(int i, int leastExclIndex, char[] buf) {
        assert (i != Integer.MIN_VALUE);
        MethodsBag.getChars(i, leastExclIndex, buf);
    }

    public static char[] itos(long l) {
        if (l == Long.MIN_VALUE) {
            return LONG_MIN_VALUE_CHARARRAY;
        }
        int size = MethodsBag.getStringSize(l);
        char[] buf = new char[size];
        MethodsBag.getChars(l, size, buf);
        return buf;
    }

    public static void itos(long l, int leastExclIndex, char[] buf) {
        assert (l != Long.MIN_VALUE);
        MethodsBag.getChars(l, leastExclIndex, buf);
    }

    public static char[] itos(BigInteger bi) {
        return bi.toString().toCharArray();
    }

    public static char[] itosReverse(int i) {
        int size = MethodsBag.getStringSize(i);
        char[] buf = new char[size];
        MethodsBag.getCharsReverse(i, 0, buf);
        return buf;
    }

    public static int itosReverse(int i, int firstIndex, char[] buf) {
        return MethodsBag.getCharsReverse(i, firstIndex, buf);
    }

    public static char[] itosReverse(long l) {
        int size = MethodsBag.getStringSize(l);
        char[] buf = new char[size];
        MethodsBag.getCharsReverse(l, 0, buf);
        return buf;
    }

    public static char[] itosReverse(BigInteger bi) {
        StringBuilder sb = new StringBuilder(bi.toString());
        return sb.reverse().toString().toCharArray();
    }
}

